/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmtraces.model.SpanLogCollection;
import com.oracle.bmc.apmtraces.model.Tag;
import com.oracle.bmc.apmtraces.model.TagMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Span
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="parentSpanKey")
    private final String parentSpanKey;
    @JsonProperty(value="traceKey")
    private final String traceKey;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="durationInMs")
    private final Long durationInMs;
    @JsonProperty(value="operationName")
    private final String operationName;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="kind")
    private final String kind;
    @JsonProperty(value="tags")
    private final List<Tag> tags;
    @JsonProperty(value="tagsMetadata")
    private final Map<String, TagMetadata> tagsMetadata;
    @JsonProperty(value="logs")
    private final List<SpanLogCollection> logs;
    @JsonProperty(value="isError")
    private final Boolean isError;
    @JsonProperty(value="sourceName")
    private final SourceName sourceName;

    @Deprecated
    @ConstructorProperties(value={"key", "parentSpanKey", "traceKey", "timeStarted", "timeEnded", "durationInMs", "operationName", "serviceName", "kind", "tags", "tagsMetadata", "logs", "isError", "sourceName"})
    public Span(String key, String parentSpanKey, String traceKey, Date timeStarted, Date timeEnded, Long durationInMs, String operationName, String serviceName, String kind, List<Tag> tags, Map<String, TagMetadata> tagsMetadata, List<SpanLogCollection> logs, Boolean isError, SourceName sourceName) {
        this.key = key;
        this.parentSpanKey = parentSpanKey;
        this.traceKey = traceKey;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.durationInMs = durationInMs;
        this.operationName = operationName;
        this.serviceName = serviceName;
        this.kind = kind;
        this.tags = tags;
        this.tagsMetadata = tagsMetadata;
        this.logs = logs;
        this.isError = isError;
        this.sourceName = sourceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getParentSpanKey() {
        return this.parentSpanKey;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public Long getDurationInMs() {
        return this.durationInMs;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getKind() {
        return this.kind;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Map<String, TagMetadata> getTagsMetadata() {
        return this.tagsMetadata;
    }

    public List<SpanLogCollection> getLogs() {
        return this.logs;
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public SourceName getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Span(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", parentSpanKey=").append(String.valueOf(this.parentSpanKey));
        sb.append(", traceKey=").append(String.valueOf(this.traceKey));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", durationInMs=").append(String.valueOf(this.durationInMs));
        sb.append(", operationName=").append(String.valueOf(this.operationName));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", kind=").append(String.valueOf(this.kind));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", tagsMetadata=").append(String.valueOf(this.tagsMetadata));
        sb.append(", logs=").append(String.valueOf(this.logs));
        sb.append(", isError=").append(String.valueOf(this.isError));
        sb.append(", sourceName=").append(String.valueOf((Object)this.sourceName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Span)) {
            return false;
        }
        Span other = (Span)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.parentSpanKey, other.parentSpanKey) && Objects.equals(this.traceKey, other.traceKey) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.durationInMs, other.durationInMs) && Objects.equals(this.operationName, other.operationName) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.kind, other.kind) && Objects.equals(this.tags, other.tags) && Objects.equals(this.tagsMetadata, other.tagsMetadata) && Objects.equals(this.logs, other.logs) && Objects.equals(this.isError, other.isError) && Objects.equals((Object)this.sourceName, (Object)other.sourceName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.parentSpanKey == null ? 43 : this.parentSpanKey.hashCode());
        result = result * 59 + (this.traceKey == null ? 43 : this.traceKey.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.durationInMs == null ? 43 : this.durationInMs.hashCode());
        result = result * 59 + (this.operationName == null ? 43 : this.operationName.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.kind == null ? 43 : this.kind.hashCode());
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + (this.tagsMetadata == null ? 43 : this.tagsMetadata.hashCode());
        result = result * 59 + (this.logs == null ? 43 : this.logs.hashCode());
        result = result * 59 + (this.isError == null ? 43 : this.isError.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SourceName implements BmcEnum
    {
        Spans("SPANS"),
        SynSpans("SYN_SPANS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SourceName> map;

        private SourceName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SourceName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SourceName.class);
            map = new HashMap<String, SourceName>();
            for (SourceName v : SourceName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="parentSpanKey")
        private String parentSpanKey;
        @JsonProperty(value="traceKey")
        private String traceKey;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="durationInMs")
        private Long durationInMs;
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="kind")
        private String kind;
        @JsonProperty(value="tags")
        private List<Tag> tags;
        @JsonProperty(value="tagsMetadata")
        private Map<String, TagMetadata> tagsMetadata;
        @JsonProperty(value="logs")
        private List<SpanLogCollection> logs;
        @JsonProperty(value="isError")
        private Boolean isError;
        @JsonProperty(value="sourceName")
        private SourceName sourceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder parentSpanKey(String parentSpanKey) {
            this.parentSpanKey = parentSpanKey;
            this.__explicitlySet__.add("parentSpanKey");
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            this.__explicitlySet__.add("traceKey");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder durationInMs(Long durationInMs) {
            this.durationInMs = durationInMs;
            this.__explicitlySet__.add("durationInMs");
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            this.__explicitlySet__.add("operationName");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            this.__explicitlySet__.add("kind");
            return this;
        }

        public Builder tags(List<Tag> tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public Builder tagsMetadata(Map<String, TagMetadata> tagsMetadata) {
            this.tagsMetadata = tagsMetadata;
            this.__explicitlySet__.add("tagsMetadata");
            return this;
        }

        public Builder logs(List<SpanLogCollection> logs) {
            this.logs = logs;
            this.__explicitlySet__.add("logs");
            return this;
        }

        public Builder isError(Boolean isError) {
            this.isError = isError;
            this.__explicitlySet__.add("isError");
            return this;
        }

        public Builder sourceName(SourceName sourceName) {
            this.sourceName = sourceName;
            this.__explicitlySet__.add("sourceName");
            return this;
        }

        public Span build() {
            Span model = new Span(this.key, this.parentSpanKey, this.traceKey, this.timeStarted, this.timeEnded, this.durationInMs, this.operationName, this.serviceName, this.kind, this.tags, this.tagsMetadata, this.logs, this.isError, this.sourceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Span model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("parentSpanKey")) {
                this.parentSpanKey(model.getParentSpanKey());
            }
            if (model.wasPropertyExplicitlySet("traceKey")) {
                this.traceKey(model.getTraceKey());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("durationInMs")) {
                this.durationInMs(model.getDurationInMs());
            }
            if (model.wasPropertyExplicitlySet("operationName")) {
                this.operationName(model.getOperationName());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("kind")) {
                this.kind(model.getKind());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("tagsMetadata")) {
                this.tagsMetadata(model.getTagsMetadata());
            }
            if (model.wasPropertyExplicitlySet("logs")) {
                this.logs(model.getLogs());
            }
            if (model.wasPropertyExplicitlySet("isError")) {
                this.isError(model.getIsError());
            }
            if (model.wasPropertyExplicitlySet("sourceName")) {
                this.sourceName(model.getSourceName());
            }
            return this;
        }
    }
}

