/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StackTraceElement
extends ExplicitlySetBmcModel {
    @JsonProperty(value="methodName")
    private final String methodName;
    @JsonProperty(value="fileName")
    private final String fileName;
    @JsonProperty(value="lineNumber")
    private final Integer lineNumber;
    @JsonProperty(value="className")
    private final String className;
    @JsonProperty(value="weightage")
    private final Float weightage;

    @Deprecated
    @ConstructorProperties(value={"methodName", "fileName", "lineNumber", "className", "weightage"})
    public StackTraceElement(String methodName, String fileName, Integer lineNumber, String className, Float weightage) {
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.className = className;
        this.weightage = weightage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public Float getWeightage() {
        return this.weightage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StackTraceElement(");
        sb.append("super=").append(super.toString());
        sb.append("methodName=").append(String.valueOf(this.methodName));
        sb.append(", fileName=").append(String.valueOf(this.fileName));
        sb.append(", lineNumber=").append(String.valueOf(this.lineNumber));
        sb.append(", className=").append(String.valueOf(this.className));
        sb.append(", weightage=").append(String.valueOf(this.weightage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement other = (StackTraceElement)((Object)o);
        return Objects.equals(this.methodName, other.methodName) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.lineNumber, other.lineNumber) && Objects.equals(this.className, other.className) && Objects.equals(this.weightage, other.weightage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.methodName == null ? 43 : this.methodName.hashCode());
        result = result * 59 + (this.fileName == null ? 43 : this.fileName.hashCode());
        result = result * 59 + (this.lineNumber == null ? 43 : this.lineNumber.hashCode());
        result = result * 59 + (this.className == null ? 43 : this.className.hashCode());
        result = result * 59 + (this.weightage == null ? 43 : this.weightage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="methodName")
        private String methodName;
        @JsonProperty(value="fileName")
        private String fileName;
        @JsonProperty(value="lineNumber")
        private Integer lineNumber;
        @JsonProperty(value="className")
        private String className;
        @JsonProperty(value="weightage")
        private Float weightage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            this.__explicitlySet__.add("methodName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.__explicitlySet__.add("fileName");
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            this.__explicitlySet__.add("lineNumber");
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            this.__explicitlySet__.add("className");
            return this;
        }

        public Builder weightage(Float weightage) {
            this.weightage = weightage;
            this.__explicitlySet__.add("weightage");
            return this;
        }

        public StackTraceElement build() {
            StackTraceElement model = new StackTraceElement(this.methodName, this.fileName, this.lineNumber, this.className, this.weightage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StackTraceElement model) {
            if (model.wasPropertyExplicitlySet("methodName")) {
                this.methodName(model.getMethodName());
            }
            if (model.wasPropertyExplicitlySet("fileName")) {
                this.fileName(model.getFileName());
            }
            if (model.wasPropertyExplicitlySet("lineNumber")) {
                this.lineNumber(model.getLineNumber());
            }
            if (model.wasPropertyExplicitlySet("className")) {
                this.className(model.getClassName());
            }
            if (model.wasPropertyExplicitlySet("weightage")) {
                this.weightage(model.getWeightage());
            }
            return this;
        }
    }
}

