/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TagMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tagType")
    private final TagType tagType;
    @JsonProperty(value="tagUnit")
    private final TagUnit tagUnit;

    @Deprecated
    @ConstructorProperties(value={"tagType", "tagUnit"})
    public TagMetadata(TagType tagType, TagUnit tagUnit) {
        this.tagType = tagType;
        this.tagUnit = tagUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TagType getTagType() {
        return this.tagType;
    }

    public TagUnit getTagUnit() {
        return this.tagUnit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TagMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("tagType=").append(String.valueOf((Object)this.tagType));
        sb.append(", tagUnit=").append(String.valueOf((Object)this.tagUnit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagMetadata)) {
            return false;
        }
        TagMetadata other = (TagMetadata)((Object)o);
        return Objects.equals((Object)this.tagType, (Object)other.tagType) && Objects.equals((Object)this.tagUnit, (Object)other.tagUnit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tagType == null ? 43 : this.tagType.hashCode());
        result = result * 59 + (this.tagUnit == null ? 43 : this.tagUnit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TagUnit implements BmcEnum
    {
        EpochTimeMs("EPOCH_TIME_MS"),
        Bytes("BYTES"),
        Count("COUNT"),
        DurationMs("DURATION_MS"),
        TraceStatus("TRACE_STATUS"),
        Percentage("PERCENTAGE"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TagUnit> map;

        private TagUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TagUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TagUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TagUnit.class);
            map = new HashMap<String, TagUnit>();
            for (TagUnit v : TagUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TagType implements BmcEnum
    {
        String("STRING"),
        Numeric("NUMERIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TagType> map;

        private TagType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TagType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TagType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TagType.class);
            map = new HashMap<String, TagType>();
            for (TagType v : TagType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tagType")
        private TagType tagType;
        @JsonProperty(value="tagUnit")
        private TagUnit tagUnit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tagType(TagType tagType) {
            this.tagType = tagType;
            this.__explicitlySet__.add("tagType");
            return this;
        }

        public Builder tagUnit(TagUnit tagUnit) {
            this.tagUnit = tagUnit;
            this.__explicitlySet__.add("tagUnit");
            return this;
        }

        public TagMetadata build() {
            TagMetadata model = new TagMetadata(this.tagType, this.tagUnit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TagMetadata model) {
            if (model.wasPropertyExplicitlySet("tagType")) {
                this.tagType(model.getTagType());
            }
            if (model.wasPropertyExplicitlySet("tagUnit")) {
                this.tagUnit(model.getTagUnit());
            }
            return this;
        }
    }
}

