/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmtraces.model.SnapshotDetail;
import com.oracle.bmc.apmtraces.model.StackTraceElement;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ThreadSnapshot
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeStamp")
    private final Date timeStamp;
    @JsonProperty(value="threadSnapshotDetails")
    private final List<SnapshotDetail> threadSnapshotDetails;
    @JsonProperty(value="stackTrace")
    private final List<StackTraceElement> stackTrace;

    @Deprecated
    @ConstructorProperties(value={"timeStamp", "threadSnapshotDetails", "stackTrace"})
    public ThreadSnapshot(Date timeStamp, List<SnapshotDetail> threadSnapshotDetails, List<StackTraceElement> stackTrace) {
        this.timeStamp = timeStamp;
        this.threadSnapshotDetails = threadSnapshotDetails;
        this.stackTrace = stackTrace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public List<SnapshotDetail> getThreadSnapshotDetails() {
        return this.threadSnapshotDetails;
    }

    public List<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ThreadSnapshot(");
        sb.append("super=").append(super.toString());
        sb.append("timeStamp=").append(String.valueOf(this.timeStamp));
        sb.append(", threadSnapshotDetails=").append(String.valueOf(this.threadSnapshotDetails));
        sb.append(", stackTrace=").append(String.valueOf(this.stackTrace));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThreadSnapshot)) {
            return false;
        }
        ThreadSnapshot other = (ThreadSnapshot)((Object)o);
        return Objects.equals(this.timeStamp, other.timeStamp) && Objects.equals(this.threadSnapshotDetails, other.threadSnapshotDetails) && Objects.equals(this.stackTrace, other.stackTrace) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeStamp == null ? 43 : this.timeStamp.hashCode());
        result = result * 59 + (this.threadSnapshotDetails == null ? 43 : this.threadSnapshotDetails.hashCode());
        result = result * 59 + (this.stackTrace == null ? 43 : this.stackTrace.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeStamp")
        private Date timeStamp;
        @JsonProperty(value="threadSnapshotDetails")
        private List<SnapshotDetail> threadSnapshotDetails;
        @JsonProperty(value="stackTrace")
        private List<StackTraceElement> stackTrace;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeStamp(Date timeStamp) {
            this.timeStamp = timeStamp;
            this.__explicitlySet__.add("timeStamp");
            return this;
        }

        public Builder threadSnapshotDetails(List<SnapshotDetail> threadSnapshotDetails) {
            this.threadSnapshotDetails = threadSnapshotDetails;
            this.__explicitlySet__.add("threadSnapshotDetails");
            return this;
        }

        public Builder stackTrace(List<StackTraceElement> stackTrace) {
            this.stackTrace = stackTrace;
            this.__explicitlySet__.add("stackTrace");
            return this;
        }

        public ThreadSnapshot build() {
            ThreadSnapshot model = new ThreadSnapshot(this.timeStamp, this.threadSnapshotDetails, this.stackTrace);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ThreadSnapshot model) {
            if (model.wasPropertyExplicitlySet("timeStamp")) {
                this.timeStamp(model.getTimeStamp());
            }
            if (model.wasPropertyExplicitlySet("threadSnapshotDetails")) {
                this.threadSnapshotDetails(model.getThreadSnapshotDetails());
            }
            if (model.wasPropertyExplicitlySet("stackTrace")) {
                this.stackTrace(model.getStackTrace());
            }
            return this;
        }
    }
}

