/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmtraces.model.BulkActivateAttributeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkActivateAttributeRequest
extends BmcRequest<BulkActivateAttributeDetails> {
    private String apmDomainId;
    private BulkActivateAttributeDetails bulkActivateAttributeDetails;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public BulkActivateAttributeDetails getBulkActivateAttributeDetails() {
        return this.bulkActivateAttributeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public BulkActivateAttributeDetails getBody$() {
        return this.bulkActivateAttributeDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).bulkActivateAttributeDetails(this.bulkActivateAttributeDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",bulkActivateAttributeDetails=").append(String.valueOf((Object)this.bulkActivateAttributeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkActivateAttributeRequest)) {
            return false;
        }
        BulkActivateAttributeRequest other = (BulkActivateAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.bulkActivateAttributeDetails, (Object)other.bulkActivateAttributeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.bulkActivateAttributeDetails == null ? 43 : this.bulkActivateAttributeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkActivateAttributeRequest, BulkActivateAttributeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private BulkActivateAttributeDetails bulkActivateAttributeDetails = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder bulkActivateAttributeDetails(BulkActivateAttributeDetails bulkActivateAttributeDetails) {
            this.bulkActivateAttributeDetails = bulkActivateAttributeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkActivateAttributeRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.bulkActivateAttributeDetails(o.getBulkActivateAttributeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkActivateAttributeRequest build() {
            BulkActivateAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkActivateAttributeDetails body) {
            this.bulkActivateAttributeDetails(body);
            return this;
        }

        public BulkActivateAttributeRequest buildWithoutInvocationCallback() {
            BulkActivateAttributeRequest request = new BulkActivateAttributeRequest();
            request.apmDomainId = this.apmDomainId;
            request.bulkActivateAttributeDetails = this.bulkActivateAttributeDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

