/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmtraces.model.BulkPinAttributeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkPinAttributeRequest
extends BmcRequest<BulkPinAttributeDetails> {
    private String apmDomainId;
    private BulkPinAttributeDetails bulkPinAttributeDetails;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public BulkPinAttributeDetails getBulkPinAttributeDetails() {
        return this.bulkPinAttributeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public BulkPinAttributeDetails getBody$() {
        return this.bulkPinAttributeDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).bulkPinAttributeDetails(this.bulkPinAttributeDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",bulkPinAttributeDetails=").append(String.valueOf((Object)this.bulkPinAttributeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkPinAttributeRequest)) {
            return false;
        }
        BulkPinAttributeRequest other = (BulkPinAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.bulkPinAttributeDetails, (Object)other.bulkPinAttributeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.bulkPinAttributeDetails == null ? 43 : this.bulkPinAttributeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkPinAttributeRequest, BulkPinAttributeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private BulkPinAttributeDetails bulkPinAttributeDetails = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder bulkPinAttributeDetails(BulkPinAttributeDetails bulkPinAttributeDetails) {
            this.bulkPinAttributeDetails = bulkPinAttributeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkPinAttributeRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.bulkPinAttributeDetails(o.getBulkPinAttributeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkPinAttributeRequest build() {
            BulkPinAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkPinAttributeDetails body) {
            this.bulkPinAttributeDetails(body);
            return this;
        }

        public BulkPinAttributeRequest buildWithoutInvocationCallback() {
            BulkPinAttributeRequest request = new BulkPinAttributeRequest();
            request.apmDomainId = this.apmDomainId;
            request.bulkPinAttributeDetails = this.bulkPinAttributeDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

