/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmtraces.model.BulkUpdateAttributeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkUpdateAttributeRequest
extends BmcRequest<BulkUpdateAttributeDetails> {
    private String apmDomainId;
    private BulkUpdateAttributeDetails bulkUpdateAttributeDetails;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public BulkUpdateAttributeDetails getBulkUpdateAttributeDetails() {
        return this.bulkUpdateAttributeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public BulkUpdateAttributeDetails getBody$() {
        return this.bulkUpdateAttributeDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).bulkUpdateAttributeDetails(this.bulkUpdateAttributeDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",bulkUpdateAttributeDetails=").append(String.valueOf((Object)this.bulkUpdateAttributeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkUpdateAttributeRequest)) {
            return false;
        }
        BulkUpdateAttributeRequest other = (BulkUpdateAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.bulkUpdateAttributeDetails, (Object)other.bulkUpdateAttributeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.bulkUpdateAttributeDetails == null ? 43 : this.bulkUpdateAttributeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkUpdateAttributeRequest, BulkUpdateAttributeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private BulkUpdateAttributeDetails bulkUpdateAttributeDetails = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder bulkUpdateAttributeDetails(BulkUpdateAttributeDetails bulkUpdateAttributeDetails) {
            this.bulkUpdateAttributeDetails = bulkUpdateAttributeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkUpdateAttributeRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.bulkUpdateAttributeDetails(o.getBulkUpdateAttributeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkUpdateAttributeRequest build() {
            BulkUpdateAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkUpdateAttributeDetails body) {
            this.bulkUpdateAttributeDetails(body);
            return this;
        }

        public BulkUpdateAttributeRequest buildWithoutInvocationCallback() {
            BulkUpdateAttributeRequest request = new BulkUpdateAttributeRequest();
            request.apmDomainId = this.apmDomainId;
            request.bulkUpdateAttributeDetails = this.bulkUpdateAttributeDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

