/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAggregatedSnapshotRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String traceKey;
    private String opcRequestId;
    private String serviceName;
    private String serverName;
    private String spanKey;
    private String spanName;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSpanKey() {
        return this.spanKey;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).traceKey(this.traceKey).opcRequestId(this.opcRequestId).serviceName(this.serviceName).serverName(this.serverName).spanKey(this.spanKey).spanName(this.spanName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",traceKey=").append(String.valueOf(this.traceKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",serviceName=").append(String.valueOf(this.serviceName));
        sb.append(",serverName=").append(String.valueOf(this.serverName));
        sb.append(",spanKey=").append(String.valueOf(this.spanKey));
        sb.append(",spanName=").append(String.valueOf(this.spanName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAggregatedSnapshotRequest)) {
            return false;
        }
        GetAggregatedSnapshotRequest other = (GetAggregatedSnapshotRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.traceKey, other.traceKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.serverName, other.serverName) && Objects.equals(this.spanKey, other.spanKey) && Objects.equals(this.spanName, other.spanName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.traceKey == null ? 43 : this.traceKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.serverName == null ? 43 : this.serverName.hashCode());
        result = result * 59 + (this.spanKey == null ? 43 : this.spanKey.hashCode());
        result = result * 59 + (this.spanName == null ? 43 : this.spanName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAggregatedSnapshotRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String traceKey = null;
        private String opcRequestId = null;
        private String serviceName = null;
        private String serverName = null;
        private String spanKey = null;
        private String spanName = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder spanKey(String spanKey) {
            this.spanKey = spanKey;
            return this;
        }

        public Builder spanName(String spanName) {
            this.spanName = spanName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAggregatedSnapshotRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.traceKey(o.getTraceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.serviceName(o.getServiceName());
            this.serverName(o.getServerName());
            this.spanKey(o.getSpanKey());
            this.spanName(o.getSpanName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAggregatedSnapshotRequest build() {
            GetAggregatedSnapshotRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAggregatedSnapshotRequest buildWithoutInvocationCallback() {
            GetAggregatedSnapshotRequest request = new GetAggregatedSnapshotRequest();
            request.apmDomainId = this.apmDomainId;
            request.traceKey = this.traceKey;
            request.opcRequestId = this.opcRequestId;
            request.serviceName = this.serviceName;
            request.serverName = this.serverName;
            request.spanKey = this.spanKey;
            request.spanName = this.spanName;
            return request;
        }
    }
}

