/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetSpanRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String spanKey;
    private String traceKey;
    private String opcRequestId;
    private Date timeSpanStartedGreaterThanOrEqualTo;
    private Date timeSpanStartedLessThan;
    private SpanNamespace spanNamespace;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getSpanKey() {
        return this.spanKey;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getTimeSpanStartedGreaterThanOrEqualTo() {
        return this.timeSpanStartedGreaterThanOrEqualTo;
    }

    public Date getTimeSpanStartedLessThan() {
        return this.timeSpanStartedLessThan;
    }

    public SpanNamespace getSpanNamespace() {
        return this.spanNamespace;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).spanKey(this.spanKey).traceKey(this.traceKey).opcRequestId(this.opcRequestId).timeSpanStartedGreaterThanOrEqualTo(this.timeSpanStartedGreaterThanOrEqualTo).timeSpanStartedLessThan(this.timeSpanStartedLessThan).spanNamespace(this.spanNamespace);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",spanKey=").append(String.valueOf(this.spanKey));
        sb.append(",traceKey=").append(String.valueOf(this.traceKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",timeSpanStartedGreaterThanOrEqualTo=").append(String.valueOf(this.timeSpanStartedGreaterThanOrEqualTo));
        sb.append(",timeSpanStartedLessThan=").append(String.valueOf(this.timeSpanStartedLessThan));
        sb.append(",spanNamespace=").append(String.valueOf((Object)this.spanNamespace));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSpanRequest)) {
            return false;
        }
        GetSpanRequest other = (GetSpanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.spanKey, other.spanKey) && Objects.equals(this.traceKey, other.traceKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.timeSpanStartedGreaterThanOrEqualTo, other.timeSpanStartedGreaterThanOrEqualTo) && Objects.equals(this.timeSpanStartedLessThan, other.timeSpanStartedLessThan) && Objects.equals((Object)this.spanNamespace, (Object)other.spanNamespace);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.spanKey == null ? 43 : this.spanKey.hashCode());
        result = result * 59 + (this.traceKey == null ? 43 : this.traceKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.timeSpanStartedGreaterThanOrEqualTo == null ? 43 : this.timeSpanStartedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeSpanStartedLessThan == null ? 43 : this.timeSpanStartedLessThan.hashCode());
        result = result * 59 + (this.spanNamespace == null ? 43 : this.spanNamespace.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSpanRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String spanKey = null;
        private String traceKey = null;
        private String opcRequestId = null;
        private Date timeSpanStartedGreaterThanOrEqualTo = null;
        private Date timeSpanStartedLessThan = null;
        private SpanNamespace spanNamespace = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder spanKey(String spanKey) {
            this.spanKey = spanKey;
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder timeSpanStartedGreaterThanOrEqualTo(Date timeSpanStartedGreaterThanOrEqualTo) {
            this.timeSpanStartedGreaterThanOrEqualTo = timeSpanStartedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeSpanStartedLessThan(Date timeSpanStartedLessThan) {
            this.timeSpanStartedLessThan = timeSpanStartedLessThan;
            return this;
        }

        public Builder spanNamespace(SpanNamespace spanNamespace) {
            this.spanNamespace = spanNamespace;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSpanRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.spanKey(o.getSpanKey());
            this.traceKey(o.getTraceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.timeSpanStartedGreaterThanOrEqualTo(o.getTimeSpanStartedGreaterThanOrEqualTo());
            this.timeSpanStartedLessThan(o.getTimeSpanStartedLessThan());
            this.spanNamespace(o.getSpanNamespace());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSpanRequest build() {
            GetSpanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSpanRequest buildWithoutInvocationCallback() {
            GetSpanRequest request = new GetSpanRequest();
            request.apmDomainId = this.apmDomainId;
            request.spanKey = this.spanKey;
            request.traceKey = this.traceKey;
            request.opcRequestId = this.opcRequestId;
            request.timeSpanStartedGreaterThanOrEqualTo = this.timeSpanStartedGreaterThanOrEqualTo;
            request.timeSpanStartedLessThan = this.timeSpanStartedLessThan;
            request.spanNamespace = this.spanNamespace;
            return request;
        }
    }

    public static enum SpanNamespace implements BmcEnum
    {
        Traces("TRACES"),
        Synthetic("SYNTHETIC");

        private final String value;
        private static Map<String, SpanNamespace> map;

        private SpanNamespace(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SpanNamespace create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SpanNamespace: " + key);
        }

        static {
            map = new HashMap<String, SpanNamespace>();
            for (SpanNamespace v : SpanNamespace.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

