/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetTraceRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String traceKey;
    private String opcRequestId;
    private Date timeTraceStartedGreaterThanOrEqualTo;
    private Date timeTraceStartedLessThan;
    private TraceNamespace traceNamespace;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getTimeTraceStartedGreaterThanOrEqualTo() {
        return this.timeTraceStartedGreaterThanOrEqualTo;
    }

    public Date getTimeTraceStartedLessThan() {
        return this.timeTraceStartedLessThan;
    }

    public TraceNamespace getTraceNamespace() {
        return this.traceNamespace;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).traceKey(this.traceKey).opcRequestId(this.opcRequestId).timeTraceStartedGreaterThanOrEqualTo(this.timeTraceStartedGreaterThanOrEqualTo).timeTraceStartedLessThan(this.timeTraceStartedLessThan).traceNamespace(this.traceNamespace);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",traceKey=").append(String.valueOf(this.traceKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",timeTraceStartedGreaterThanOrEqualTo=").append(String.valueOf(this.timeTraceStartedGreaterThanOrEqualTo));
        sb.append(",timeTraceStartedLessThan=").append(String.valueOf(this.timeTraceStartedLessThan));
        sb.append(",traceNamespace=").append(String.valueOf((Object)this.traceNamespace));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTraceRequest)) {
            return false;
        }
        GetTraceRequest other = (GetTraceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.traceKey, other.traceKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.timeTraceStartedGreaterThanOrEqualTo, other.timeTraceStartedGreaterThanOrEqualTo) && Objects.equals(this.timeTraceStartedLessThan, other.timeTraceStartedLessThan) && Objects.equals((Object)this.traceNamespace, (Object)other.traceNamespace);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.traceKey == null ? 43 : this.traceKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.timeTraceStartedGreaterThanOrEqualTo == null ? 43 : this.timeTraceStartedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeTraceStartedLessThan == null ? 43 : this.timeTraceStartedLessThan.hashCode());
        result = result * 59 + (this.traceNamespace == null ? 43 : this.traceNamespace.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTraceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String traceKey = null;
        private String opcRequestId = null;
        private Date timeTraceStartedGreaterThanOrEqualTo = null;
        private Date timeTraceStartedLessThan = null;
        private TraceNamespace traceNamespace = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder timeTraceStartedGreaterThanOrEqualTo(Date timeTraceStartedGreaterThanOrEqualTo) {
            this.timeTraceStartedGreaterThanOrEqualTo = timeTraceStartedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeTraceStartedLessThan(Date timeTraceStartedLessThan) {
            this.timeTraceStartedLessThan = timeTraceStartedLessThan;
            return this;
        }

        public Builder traceNamespace(TraceNamespace traceNamespace) {
            this.traceNamespace = traceNamespace;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTraceRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.traceKey(o.getTraceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.timeTraceStartedGreaterThanOrEqualTo(o.getTimeTraceStartedGreaterThanOrEqualTo());
            this.timeTraceStartedLessThan(o.getTimeTraceStartedLessThan());
            this.traceNamespace(o.getTraceNamespace());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTraceRequest build() {
            GetTraceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTraceRequest buildWithoutInvocationCallback() {
            GetTraceRequest request = new GetTraceRequest();
            request.apmDomainId = this.apmDomainId;
            request.traceKey = this.traceKey;
            request.opcRequestId = this.opcRequestId;
            request.timeTraceStartedGreaterThanOrEqualTo = this.timeTraceStartedGreaterThanOrEqualTo;
            request.timeTraceStartedLessThan = this.timeTraceStartedLessThan;
            request.traceNamespace = this.traceNamespace;
            return request;
        }
    }

    public static enum TraceNamespace implements BmcEnum
    {
        Traces("TRACES"),
        Synthetic("SYNTHETIC");

        private final String value;
        private static Map<String, TraceNamespace> map;

        private TraceNamespace(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TraceNamespace create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TraceNamespace: " + key);
        }

        static {
            map = new HashMap<String, TraceNamespace>();
            for (TraceNamespace v : TraceNamespace.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

