/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PutToggleAutoActivateRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private Boolean isAutoActivateOn;
    private DataKeyType dataKeyType;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public Boolean getIsAutoActivateOn() {
        return this.isAutoActivateOn;
    }

    public DataKeyType getDataKeyType() {
        return this.dataKeyType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).isAutoActivateOn(this.isAutoActivateOn).dataKeyType(this.dataKeyType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",isAutoActivateOn=").append(String.valueOf(this.isAutoActivateOn));
        sb.append(",dataKeyType=").append(String.valueOf((Object)this.dataKeyType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutToggleAutoActivateRequest)) {
            return false;
        }
        PutToggleAutoActivateRequest other = (PutToggleAutoActivateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.isAutoActivateOn, other.isAutoActivateOn) && Objects.equals((Object)this.dataKeyType, (Object)other.dataKeyType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.isAutoActivateOn == null ? 43 : this.isAutoActivateOn.hashCode());
        result = result * 59 + (this.dataKeyType == null ? 43 : this.dataKeyType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PutToggleAutoActivateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private Boolean isAutoActivateOn = null;
        private DataKeyType dataKeyType = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder isAutoActivateOn(Boolean isAutoActivateOn) {
            this.isAutoActivateOn = isAutoActivateOn;
            return this;
        }

        public Builder dataKeyType(DataKeyType dataKeyType) {
            this.dataKeyType = dataKeyType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutToggleAutoActivateRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.isAutoActivateOn(o.getIsAutoActivateOn());
            this.dataKeyType(o.getDataKeyType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutToggleAutoActivateRequest build() {
            PutToggleAutoActivateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public PutToggleAutoActivateRequest buildWithoutInvocationCallback() {
            PutToggleAutoActivateRequest request = new PutToggleAutoActivateRequest();
            request.apmDomainId = this.apmDomainId;
            request.isAutoActivateOn = this.isAutoActivateOn;
            request.dataKeyType = this.dataKeyType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum DataKeyType implements BmcEnum
    {
        PrivateDataKey("PRIVATE_DATA_KEY"),
        PublicDataKey("PUBLIC_DATA_KEY");

        private final String value;
        private static Map<String, DataKeyType> map;

        private DataKeyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataKeyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DataKeyType: " + key);
        }

        static {
            map = new HashMap<String, DataKeyType>();
            for (DataKeyType v : DataKeyType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

