/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.applicationmigration.model.Migration;
import com.oracle.bmc.applicationmigration.requests.GetMigrationRequest;
import com.oracle.bmc.applicationmigration.responses.GetMigrationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMigrationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetMigrationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetMigrationRequest interceptRequest(GetMigrationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetMigrationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20191031").path("migrations").path(HttpUtils.encodePathSegment((String)request.getMigrationId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetMigrationResponse> fromResponse() {
        Function<Response, GetMigrationResponse> transformer = new Function<Response, GetMigrationResponse>(){

            public GetMigrationResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.applicationmigration.responses.GetMigrationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Migration.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetMigrationResponse.Builder builder = GetMigrationResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.migration((Migration)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                GetMigrationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

