/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelWorkRequestRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"workRequestId", "opcRequestId", "ifMatch"})
    CancelWorkRequestRequest(String workRequestId, String opcRequestId, String ifMatch) {
        this.workRequestId = workRequestId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelWorkRequestRequest, Void> {
        private String workRequestId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelWorkRequestRequest build() {
            CancelWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public CancelWorkRequestRequest buildWithoutInvocationCallback() {
            return new CancelWorkRequestRequest(this.workRequestId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "CancelWorkRequestRequest.Builder(workRequestId=" + this.workRequestId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

