/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class MigrateApplicationRequest
extends BmcRequest<Void> {
    private String migrationId;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    @ConstructorProperties(value={"migrationId", "opcRequestId", "ifMatch", "opcRetryToken"})
    MigrateApplicationRequest(String migrationId, String opcRequestId, String ifMatch, String opcRetryToken) {
        this.migrationId = migrationId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMigrationId() {
        return this.migrationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<MigrateApplicationRequest, Void> {
        private String migrationId;
        private String opcRequestId;
        private String ifMatch;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(MigrateApplicationRequest o) {
            this.migrationId(o.getMigrationId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public MigrateApplicationRequest build() {
            MigrateApplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public MigrateApplicationRequest buildWithoutInvocationCallback() {
            return new MigrateApplicationRequest(this.migrationId, this.opcRequestId, this.ifMatch, this.opcRetryToken);
        }

        public String toString() {
            return "MigrateApplicationRequest.Builder(migrationId=" + this.migrationId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

