/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.applicationmigration.model.UpdateSourceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateSourceRequest
extends BmcRequest<UpdateSourceDetails> {
    private String sourceId;
    private UpdateSourceDetails updateSourceDetails;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public UpdateSourceDetails getBody$() {
        return this.updateSourceDetails;
    }

    @ConstructorProperties(value={"sourceId", "updateSourceDetails", "opcRequestId", "ifMatch"})
    UpdateSourceRequest(String sourceId, UpdateSourceDetails updateSourceDetails, String opcRequestId, String ifMatch) {
        this.sourceId = sourceId;
        this.updateSourceDetails = updateSourceDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public UpdateSourceDetails getUpdateSourceDetails() {
        return this.updateSourceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSourceRequest, UpdateSourceDetails> {
        private String sourceId;
        private UpdateSourceDetails updateSourceDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSourceRequest o) {
            this.sourceId(o.getSourceId());
            this.updateSourceDetails(o.getUpdateSourceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSourceRequest build() {
            UpdateSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSourceDetails body) {
            this.updateSourceDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder updateSourceDetails(UpdateSourceDetails updateSourceDetails) {
            this.updateSourceDetails = updateSourceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateSourceRequest buildWithoutInvocationCallback() {
            return new UpdateSourceRequest(this.sourceId, this.updateSourceDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateSourceRequest.Builder(sourceId=" + this.sourceId + ", updateSourceDetails=" + this.updateSourceDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

