/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.applicationmigration.ApplicationMigration;
import com.oracle.bmc.applicationmigration.ApplicationMigrationPaginators;
import com.oracle.bmc.applicationmigration.ApplicationMigrationWaiters;
import com.oracle.bmc.applicationmigration.model.Migration;
import com.oracle.bmc.applicationmigration.model.MigrationSummary;
import com.oracle.bmc.applicationmigration.model.Source;
import com.oracle.bmc.applicationmigration.model.SourceApplicationSummary;
import com.oracle.bmc.applicationmigration.model.SourceSummary;
import com.oracle.bmc.applicationmigration.model.WorkRequest;
import com.oracle.bmc.applicationmigration.model.WorkRequestError;
import com.oracle.bmc.applicationmigration.model.WorkRequestLogEntry;
import com.oracle.bmc.applicationmigration.model.WorkRequestSummary;
import com.oracle.bmc.applicationmigration.requests.CancelWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeSourceCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.CreateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.CreateSourceRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.GetSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ListMigrationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourceApplicationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourcesRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.applicationmigration.requests.MigrateApplicationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateSourceRequest;
import com.oracle.bmc.applicationmigration.responses.CancelWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeSourceCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.CreateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.CreateSourceResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.GetSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ListMigrationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourceApplicationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourcesResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.applicationmigration.responses.MigrateApplicationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateSourceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMigrationClient
extends BaseSyncClient
implements ApplicationMigration {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLICATIONMIGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://applicationmigration.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMigrationClient.class);
    private final ApplicationMigrationWaiters waiters;
    private final ApplicationMigrationPaginators paginators;

    ApplicationMigrationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ApplicationMigration-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApplicationMigrationWaiters(executorService, this);
        this.paginators = new ApplicationMigrationPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("ApplicationMigration", "CancelWorkRequest", "").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20191031").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeMigrationCompartmentResponse changeMigrationCompartment(ChangeMigrationCompartmentRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMigrationCompartmentDetails(), "changeMigrationCompartmentDetails is required");
        return (ChangeMigrationCompartmentResponse)this.clientCall(request, ChangeMigrationCompartmentResponse::builder).logger(LOG, "changeMigrationCompartment").serviceDetails("ApplicationMigration", "ChangeMigrationCompartment", "").method(Method.POST).requestBuilder(ChangeMigrationCompartmentRequest::builder).basePath("/20191031").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeMigrationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeMigrationCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeSourceCompartmentResponse changeSourceCompartment(ChangeSourceCompartmentRequest request) {
        Validate.notBlank((String)request.getSourceId(), (String)"sourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSourceCompartmentDetails(), "changeSourceCompartmentDetails is required");
        return (ChangeSourceCompartmentResponse)this.clientCall(request, ChangeSourceCompartmentResponse::builder).logger(LOG, "changeSourceCompartment").serviceDetails("ApplicationMigration", "ChangeSourceCompartment", "").method(Method.POST).requestBuilder(ChangeSourceCompartmentRequest::builder).basePath("/20191031").appendPathParam("sources").appendPathParam(request.getSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSourceCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeSourceCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateMigrationResponse createMigration(CreateMigrationRequest request) {
        Objects.requireNonNull(request.getCreateMigrationDetails(), "createMigrationDetails is required");
        return (CreateMigrationResponse)this.clientCall(request, CreateMigrationResponse::builder).logger(LOG, "createMigration").serviceDetails("ApplicationMigration", "CreateMigration", "").method(Method.POST).requestBuilder(CreateMigrationRequest::builder).basePath("/20191031").appendPathParam("migrations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Migration.class, CreateMigrationResponse.Builder::migration).handleResponseHeaderString("etag", CreateMigrationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateMigrationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateSourceResponse createSource(CreateSourceRequest request) {
        Objects.requireNonNull(request.getCreateSourceDetails(), "createSourceDetails is required");
        return (CreateSourceResponse)this.clientCall(request, CreateSourceResponse::builder).logger(LOG, "createSource").serviceDetails("ApplicationMigration", "CreateSource", "").method(Method.POST).requestBuilder(CreateSourceRequest::builder).basePath("/20191031").appendPathParam("sources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Source.class, CreateSourceResponse.Builder::source).handleResponseHeaderString("opc-request-id", CreateSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateSourceResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteMigrationResponse deleteMigration(DeleteMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (DeleteMigrationResponse)this.clientCall(request, DeleteMigrationResponse::builder).logger(LOG, "deleteMigration").serviceDetails("ApplicationMigration", "DeleteMigration", "").method(Method.DELETE).requestBuilder(DeleteMigrationRequest::builder).basePath("/20191031").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteMigrationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteSourceResponse deleteSource(DeleteSourceRequest request) {
        Validate.notBlank((String)request.getSourceId(), (String)"sourceId must not be blank", (Object[])new Object[0]);
        return (DeleteSourceResponse)this.clientCall(request, DeleteSourceResponse::builder).logger(LOG, "deleteSource").serviceDetails("ApplicationMigration", "DeleteSource", "").method(Method.DELETE).requestBuilder(DeleteSourceRequest::builder).basePath("/20191031").appendPathParam("sources").appendPathParam(request.getSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetMigrationResponse getMigration(GetMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (GetMigrationResponse)this.clientCall(request, GetMigrationResponse::builder).logger(LOG, "getMigration").serviceDetails("ApplicationMigration", "GetMigration", "").method(Method.GET).requestBuilder(GetMigrationRequest::builder).basePath("/20191031").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Migration.class, GetMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", GetMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetMigrationResponse.Builder::etag).callSync();
    }

    @Override
    public GetSourceResponse getSource(GetSourceRequest request) {
        Validate.notBlank((String)request.getSourceId(), (String)"sourceId must not be blank", (Object[])new Object[0]);
        return (GetSourceResponse)this.clientCall(request, GetSourceResponse::builder).logger(LOG, "getSource").serviceDetails("ApplicationMigration", "GetSource", "").method(Method.GET).requestBuilder(GetSourceRequest::builder).basePath("/20191031").appendPathParam("sources").appendPathParam(request.getSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Source.class, GetSourceResponse.Builder::source).handleResponseHeaderString("opc-request-id", GetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSourceResponse.Builder::etag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ApplicationMigration", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20191031").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).callSync();
    }

    @Override
    public ListMigrationsResponse listMigrations(ListMigrationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListMigrationsResponse)this.clientCall(request, ListMigrationsResponse::builder).logger(LOG, "listMigrations").serviceDetails("ApplicationMigration", "ListMigrations", "").method(Method.GET).requestBuilder(ListMigrationsRequest::builder).basePath("/20191031").appendPathParam("migrations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(MigrationSummary.class, ListMigrationsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListMigrationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSourceApplicationsResponse listSourceApplications(ListSourceApplicationsRequest request) {
        Validate.notBlank((String)request.getSourceId(), (String)"sourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSourceApplicationsResponse)this.clientCall(request, ListSourceApplicationsResponse::builder).logger(LOG, "listSourceApplications").serviceDetails("ApplicationMigration", "ListSourceApplications", "").method(Method.GET).requestBuilder(ListSourceApplicationsRequest::builder).basePath("/20191031").appendPathParam("sources").appendPathParam(request.getSourceId()).appendPathParam("applications").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SourceApplicationSummary.class, ListSourceApplicationsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSourceApplicationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSourceApplicationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSourcesResponse listSources(ListSourcesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSourcesResponse)this.clientCall(request, ListSourcesResponse::builder).logger(LOG, "listSources").serviceDetails("ApplicationMigration", "ListSources", "").method(Method.GET).requestBuilder(ListSourcesRequest::builder).basePath("/20191031").appendPathParam("sources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SourceSummary.class, ListSourcesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ApplicationMigration", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20191031").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ApplicationMigration", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20191031").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ApplicationMigration", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20191031").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public MigrateApplicationResponse migrateApplication(MigrateApplicationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (MigrateApplicationResponse)this.clientCall(request, MigrateApplicationResponse::builder).logger(LOG, "migrateApplication").serviceDetails("ApplicationMigration", "MigrateApplication", "").method(Method.POST).requestBuilder(MigrateApplicationRequest::builder).basePath("/20191031").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("migrate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", MigrateApplicationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", MigrateApplicationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateMigrationResponse updateMigration(UpdateMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMigrationDetails(), "updateMigrationDetails is required");
        return (UpdateMigrationResponse)this.clientCall(request, UpdateMigrationResponse::builder).logger(LOG, "updateMigration").serviceDetails("ApplicationMigration", "UpdateMigration", "").method(Method.PUT).requestBuilder(UpdateMigrationRequest::builder).basePath("/20191031").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateMigrationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateSourceResponse updateSource(UpdateSourceRequest request) {
        Validate.notBlank((String)request.getSourceId(), (String)"sourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSourceDetails(), "updateSourceDetails is required");
        return (UpdateSourceResponse)this.clientCall(request, UpdateSourceResponse::builder).logger(LOG, "updateSource").serviceDetails("ApplicationMigration", "UpdateSource", "").method(Method.PUT).requestBuilder(UpdateSourceRequest::builder).basePath("/20191031").appendPathParam("sources").appendPathParam(request.getSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ApplicationMigrationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApplicationMigrationPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ApplicationMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApplicationMigrationClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApplicationMigrationClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApplicationMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApplicationMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApplicationMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApplicationMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplicationMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplicationMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplicationMigrationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "applicationmigration";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"applicationmigration");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApplicationMigrationClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApplicationMigrationClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

