/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.applicationmigration.model.CreateMigrationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateMigrationRequest
extends BmcRequest<CreateMigrationDetails> {
    private CreateMigrationDetails createMigrationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateMigrationDetails getCreateMigrationDetails() {
        return this.createMigrationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateMigrationDetails getBody$() {
        return this.createMigrationDetails;
    }

    public Builder toBuilder() {
        return new Builder().createMigrationDetails(this.createMigrationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createMigrationDetails=").append(String.valueOf((Object)this.createMigrationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMigrationRequest)) {
            return false;
        }
        CreateMigrationRequest other = (CreateMigrationRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createMigrationDetails, (Object)other.createMigrationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createMigrationDetails == null ? 43 : this.createMigrationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateMigrationRequest, CreateMigrationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateMigrationDetails createMigrationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createMigrationDetails(CreateMigrationDetails createMigrationDetails) {
            this.createMigrationDetails = createMigrationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateMigrationRequest o) {
            this.createMigrationDetails(o.getCreateMigrationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateMigrationRequest build() {
            CreateMigrationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateMigrationDetails body) {
            this.createMigrationDetails(body);
            return this;
        }

        public CreateMigrationRequest buildWithoutInvocationCallback() {
            CreateMigrationRequest request = new CreateMigrationRequest();
            request.createMigrationDetails = this.createMigrationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

