/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.appmgmtcontrol;

import com.oracle.bmc.appmgmtcontrol.AppmgmtControl;
import com.oracle.bmc.appmgmtcontrol.model.MonitoredInstance;
import com.oracle.bmc.appmgmtcontrol.requests.GetMonitoredInstanceRequest;
import com.oracle.bmc.appmgmtcontrol.requests.GetWorkRequestRequest;
import com.oracle.bmc.appmgmtcontrol.responses.GetMonitoredInstanceResponse;
import com.oracle.bmc.appmgmtcontrol.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AppmgmtControlWaiters {
    private final ExecutorService executorService;
    private final AppmgmtControl client;

    public AppmgmtControlWaiters(ExecutorService executorService, AppmgmtControl client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetMonitoredInstanceRequest, GetMonitoredInstanceResponse> forMonitoredInstance(GetMonitoredInstanceRequest request, MonitoredInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMonitoredInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMonitoredInstanceRequest, GetMonitoredInstanceResponse> forMonitoredInstance(GetMonitoredInstanceRequest request, MonitoredInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMonitoredInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMonitoredInstanceRequest, GetMonitoredInstanceResponse> forMonitoredInstance(GetMonitoredInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MonitoredInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMonitoredInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMonitoredInstanceRequest, GetMonitoredInstanceResponse> forMonitoredInstance(BmcGenericWaiter waiter, GetMonitoredInstanceRequest request, MonitoredInstance.LifecycleState ... targetStates) {
        final HashSet<MonitoredInstance.LifecycleState> targetStatesSet = new HashSet<MonitoredInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMonitoredInstanceRequest, GetMonitoredInstanceResponse>(){

            @Override
            public GetMonitoredInstanceResponse apply(GetMonitoredInstanceRequest request) {
                return AppmgmtControlWaiters.this.client.getMonitoredInstance(request);
            }
        }, (Predicate)new Predicate<GetMonitoredInstanceResponse>(){

            @Override
            public boolean test(GetMonitoredInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getMonitoredInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MonitoredInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return AppmgmtControlWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

