/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.artifacts.ArtifactsAsync;
import com.oracle.bmc.artifacts.internal.http.ChangeContainerRepositoryCompartmentConverter;
import com.oracle.bmc.artifacts.internal.http.CreateContainerRepositoryConverter;
import com.oracle.bmc.artifacts.internal.http.DeleteContainerImageConverter;
import com.oracle.bmc.artifacts.internal.http.DeleteContainerRepositoryConverter;
import com.oracle.bmc.artifacts.internal.http.GetContainerConfigurationConverter;
import com.oracle.bmc.artifacts.internal.http.GetContainerImageConverter;
import com.oracle.bmc.artifacts.internal.http.GetContainerRepositoryConverter;
import com.oracle.bmc.artifacts.internal.http.ListContainerImagesConverter;
import com.oracle.bmc.artifacts.internal.http.ListContainerRepositoriesConverter;
import com.oracle.bmc.artifacts.internal.http.RemoveContainerVersionConverter;
import com.oracle.bmc.artifacts.internal.http.RestoreContainerImageConverter;
import com.oracle.bmc.artifacts.internal.http.UpdateContainerConfigurationConverter;
import com.oracle.bmc.artifacts.internal.http.UpdateContainerRepositoryConverter;
import com.oracle.bmc.artifacts.requests.ChangeContainerRepositoryCompartmentRequest;
import com.oracle.bmc.artifacts.requests.CreateContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerImageRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.GetContainerConfigurationRequest;
import com.oracle.bmc.artifacts.requests.GetContainerImageRequest;
import com.oracle.bmc.artifacts.requests.GetContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerRepositoriesRequest;
import com.oracle.bmc.artifacts.requests.RemoveContainerVersionRequest;
import com.oracle.bmc.artifacts.requests.RestoreContainerImageRequest;
import com.oracle.bmc.artifacts.requests.UpdateContainerConfigurationRequest;
import com.oracle.bmc.artifacts.requests.UpdateContainerRepositoryRequest;
import com.oracle.bmc.artifacts.responses.ChangeContainerRepositoryCompartmentResponse;
import com.oracle.bmc.artifacts.responses.CreateContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerImageResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.GetContainerConfigurationResponse;
import com.oracle.bmc.artifacts.responses.GetContainerImageResponse;
import com.oracle.bmc.artifacts.responses.GetContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.ListContainerImagesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerRepositoriesResponse;
import com.oracle.bmc.artifacts.responses.RemoveContainerVersionResponse;
import com.oracle.bmc.artifacts.responses.RestoreContainerImageResponse;
import com.oracle.bmc.artifacts.responses.UpdateContainerConfigurationResponse;
import com.oracle.bmc.artifacts.responses.UpdateContainerRepositoryResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactsAsyncClient
implements ArtifactsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ARTIFACTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://artifacts.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ArtifactsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ArtifactsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ArtifactsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ArtifactsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeContainerRepositoryCompartmentResponse> changeContainerRepositoryCompartment(ChangeContainerRepositoryCompartmentRequest request, AsyncHandler<ChangeContainerRepositoryCompartmentRequest, ChangeContainerRepositoryCompartmentResponse> handler) {
        LOG.trace("Called async changeContainerRepositoryCompartment");
        ChangeContainerRepositoryCompartmentRequest interceptedRequest = ChangeContainerRepositoryCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeContainerRepositoryCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeContainerRepositoryCompartmentResponse> transformer = ChangeContainerRepositoryCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeContainerRepositoryCompartmentRequest, ChangeContainerRepositoryCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeContainerRepositoryCompartmentRequest, ChangeContainerRepositoryCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateContainerRepositoryResponse> createContainerRepository(CreateContainerRepositoryRequest request, AsyncHandler<CreateContainerRepositoryRequest, CreateContainerRepositoryResponse> handler) {
        LOG.trace("Called async createContainerRepository");
        CreateContainerRepositoryRequest interceptedRequest = CreateContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateContainerRepositoryResponse> transformer = CreateContainerRepositoryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateContainerRepositoryRequest, CreateContainerRepositoryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateContainerRepositoryRequest, CreateContainerRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteContainerImageResponse> deleteContainerImage(DeleteContainerImageRequest request, AsyncHandler<DeleteContainerImageRequest, DeleteContainerImageResponse> handler) {
        LOG.trace("Called async deleteContainerImage");
        DeleteContainerImageRequest interceptedRequest = DeleteContainerImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteContainerImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteContainerImageResponse> transformer = DeleteContainerImageConverter.fromResponse();
        AsyncHandler<DeleteContainerImageRequest, DeleteContainerImageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteContainerImageRequest, DeleteContainerImageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteContainerRepositoryResponse> deleteContainerRepository(DeleteContainerRepositoryRequest request, AsyncHandler<DeleteContainerRepositoryRequest, DeleteContainerRepositoryResponse> handler) {
        LOG.trace("Called async deleteContainerRepository");
        DeleteContainerRepositoryRequest interceptedRequest = DeleteContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteContainerRepositoryResponse> transformer = DeleteContainerRepositoryConverter.fromResponse();
        AsyncHandler<DeleteContainerRepositoryRequest, DeleteContainerRepositoryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteContainerRepositoryRequest, DeleteContainerRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetContainerConfigurationResponse> getContainerConfiguration(GetContainerConfigurationRequest request, AsyncHandler<GetContainerConfigurationRequest, GetContainerConfigurationResponse> handler) {
        LOG.trace("Called async getContainerConfiguration");
        GetContainerConfigurationRequest interceptedRequest = GetContainerConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetContainerConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetContainerConfigurationResponse> transformer = GetContainerConfigurationConverter.fromResponse();
        AsyncHandler<GetContainerConfigurationRequest, GetContainerConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetContainerConfigurationRequest, GetContainerConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetContainerImageResponse> getContainerImage(GetContainerImageRequest request, AsyncHandler<GetContainerImageRequest, GetContainerImageResponse> handler) {
        LOG.trace("Called async getContainerImage");
        GetContainerImageRequest interceptedRequest = GetContainerImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetContainerImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetContainerImageResponse> transformer = GetContainerImageConverter.fromResponse();
        AsyncHandler<GetContainerImageRequest, GetContainerImageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetContainerImageRequest, GetContainerImageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetContainerRepositoryResponse> getContainerRepository(GetContainerRepositoryRequest request, AsyncHandler<GetContainerRepositoryRequest, GetContainerRepositoryResponse> handler) {
        LOG.trace("Called async getContainerRepository");
        GetContainerRepositoryRequest interceptedRequest = GetContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetContainerRepositoryResponse> transformer = GetContainerRepositoryConverter.fromResponse();
        AsyncHandler<GetContainerRepositoryRequest, GetContainerRepositoryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetContainerRepositoryRequest, GetContainerRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListContainerImagesResponse> listContainerImages(ListContainerImagesRequest request, AsyncHandler<ListContainerImagesRequest, ListContainerImagesResponse> handler) {
        LOG.trace("Called async listContainerImages");
        ListContainerImagesRequest interceptedRequest = ListContainerImagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListContainerImagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListContainerImagesResponse> transformer = ListContainerImagesConverter.fromResponse();
        AsyncHandler<ListContainerImagesRequest, ListContainerImagesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListContainerImagesRequest, ListContainerImagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListContainerRepositoriesResponse> listContainerRepositories(ListContainerRepositoriesRequest request, AsyncHandler<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse> handler) {
        LOG.trace("Called async listContainerRepositories");
        ListContainerRepositoriesRequest interceptedRequest = ListContainerRepositoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListContainerRepositoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListContainerRepositoriesResponse> transformer = ListContainerRepositoriesConverter.fromResponse();
        AsyncHandler<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveContainerVersionResponse> removeContainerVersion(RemoveContainerVersionRequest request, AsyncHandler<RemoveContainerVersionRequest, RemoveContainerVersionResponse> handler) {
        LOG.trace("Called async removeContainerVersion");
        RemoveContainerVersionRequest interceptedRequest = RemoveContainerVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveContainerVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveContainerVersionResponse> transformer = RemoveContainerVersionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RemoveContainerVersionRequest, RemoveContainerVersionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveContainerVersionRequest, RemoveContainerVersionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreContainerImageResponse> restoreContainerImage(RestoreContainerImageRequest request, AsyncHandler<RestoreContainerImageRequest, RestoreContainerImageResponse> handler) {
        LOG.trace("Called async restoreContainerImage");
        RestoreContainerImageRequest interceptedRequest = RestoreContainerImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreContainerImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreContainerImageResponse> transformer = RestoreContainerImageConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestoreContainerImageRequest, RestoreContainerImageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreContainerImageRequest, RestoreContainerImageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateContainerConfigurationResponse> updateContainerConfiguration(UpdateContainerConfigurationRequest request, AsyncHandler<UpdateContainerConfigurationRequest, UpdateContainerConfigurationResponse> handler) {
        LOG.trace("Called async updateContainerConfiguration");
        UpdateContainerConfigurationRequest interceptedRequest = UpdateContainerConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateContainerConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateContainerConfigurationResponse> transformer = UpdateContainerConfigurationConverter.fromResponse();
        AsyncHandler<UpdateContainerConfigurationRequest, UpdateContainerConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateContainerConfigurationRequest, UpdateContainerConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateContainerRepositoryResponse> updateContainerRepository(UpdateContainerRepositoryRequest request, AsyncHandler<UpdateContainerRepositoryRequest, UpdateContainerRepositoryResponse> handler) {
        LOG.trace("Called async updateContainerRepository");
        UpdateContainerRepositoryRequest interceptedRequest = UpdateContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateContainerRepositoryResponse> transformer = UpdateContainerRepositoryConverter.fromResponse();
        AsyncHandler<UpdateContainerRepositoryRequest, UpdateContainerRepositoryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateContainerRepositoryRequest, UpdateContainerRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ArtifactsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ArtifactsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ArtifactsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

