/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetContainerImageRequest
extends BmcRequest<Void> {
    private String imageId;
    private String opcRequestId;

    @ConstructorProperties(value={"imageId", "opcRequestId"})
    GetContainerImageRequest(String imageId, String opcRequestId) {
        this.imageId = imageId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetContainerImageRequest, Void> {
        private String imageId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetContainerImageRequest o) {
            this.imageId(o.getImageId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetContainerImageRequest build() {
            GetContainerImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetContainerImageRequest buildWithoutInvocationCallback() {
            return new GetContainerImageRequest(this.imageId, this.opcRequestId);
        }

        public String toString() {
            return "GetContainerImageRequest.Builder(imageId=" + this.imageId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

