/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.artifacts.model.ContainerRepository;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerRepositorySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="imageCount")
    private final Integer imageCount;
    @JsonProperty(value="isPublic")
    private final Boolean isPublic;
    @JsonProperty(value="layerCount")
    private final Integer layerCount;
    @JsonProperty(value="layersSizeInBytes")
    private final Long layersSizeInBytes;
    @JsonProperty(value="lifecycleState")
    private final ContainerRepository.LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="billableSizeInGBs")
    private final Long billableSizeInGBs;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "id", "imageCount", "isPublic", "layerCount", "layersSizeInBytes", "lifecycleState", "timeCreated", "billableSizeInGBs"})
    public ContainerRepositorySummary(String compartmentId, String displayName, String id, Integer imageCount, Boolean isPublic, Integer layerCount, Long layersSizeInBytes, ContainerRepository.LifecycleState lifecycleState, Date timeCreated, Long billableSizeInGBs) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.id = id;
        this.imageCount = imageCount;
        this.isPublic = isPublic;
        this.layerCount = layerCount;
        this.layersSizeInBytes = layersSizeInBytes;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.billableSizeInGBs = billableSizeInGBs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public Integer getImageCount() {
        return this.imageCount;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public Integer getLayerCount() {
        return this.layerCount;
    }

    public Long getLayersSizeInBytes() {
        return this.layersSizeInBytes;
    }

    public ContainerRepository.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Long getBillableSizeInGBs() {
        return this.billableSizeInGBs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerRepositorySummary(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", imageCount=").append(String.valueOf(this.imageCount));
        sb.append(", isPublic=").append(String.valueOf(this.isPublic));
        sb.append(", layerCount=").append(String.valueOf(this.layerCount));
        sb.append(", layersSizeInBytes=").append(String.valueOf(this.layersSizeInBytes));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", billableSizeInGBs=").append(String.valueOf(this.billableSizeInGBs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerRepositorySummary)) {
            return false;
        }
        ContainerRepositorySummary other = (ContainerRepositorySummary)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.imageCount, other.imageCount) && Objects.equals(this.isPublic, other.isPublic) && Objects.equals(this.layerCount, other.layerCount) && Objects.equals(this.layersSizeInBytes, other.layersSizeInBytes) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.billableSizeInGBs, other.billableSizeInGBs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.imageCount == null ? 43 : this.imageCount.hashCode());
        result = result * 59 + (this.isPublic == null ? 43 : this.isPublic.hashCode());
        result = result * 59 + (this.layerCount == null ? 43 : this.layerCount.hashCode());
        result = result * 59 + (this.layersSizeInBytes == null ? 43 : this.layersSizeInBytes.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.billableSizeInGBs == null ? 43 : this.billableSizeInGBs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="imageCount")
        private Integer imageCount;
        @JsonProperty(value="isPublic")
        private Boolean isPublic;
        @JsonProperty(value="layerCount")
        private Integer layerCount;
        @JsonProperty(value="layersSizeInBytes")
        private Long layersSizeInBytes;
        @JsonProperty(value="lifecycleState")
        private ContainerRepository.LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="billableSizeInGBs")
        private Long billableSizeInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder imageCount(Integer imageCount) {
            this.imageCount = imageCount;
            this.__explicitlySet__.add("imageCount");
            return this;
        }

        public Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            this.__explicitlySet__.add("isPublic");
            return this;
        }

        public Builder layerCount(Integer layerCount) {
            this.layerCount = layerCount;
            this.__explicitlySet__.add("layerCount");
            return this;
        }

        public Builder layersSizeInBytes(Long layersSizeInBytes) {
            this.layersSizeInBytes = layersSizeInBytes;
            this.__explicitlySet__.add("layersSizeInBytes");
            return this;
        }

        public Builder lifecycleState(ContainerRepository.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder billableSizeInGBs(Long billableSizeInGBs) {
            this.billableSizeInGBs = billableSizeInGBs;
            this.__explicitlySet__.add("billableSizeInGBs");
            return this;
        }

        public ContainerRepositorySummary build() {
            ContainerRepositorySummary model = new ContainerRepositorySummary(this.compartmentId, this.displayName, this.id, this.imageCount, this.isPublic, this.layerCount, this.layersSizeInBytes, this.lifecycleState, this.timeCreated, this.billableSizeInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerRepositorySummary model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("imageCount")) {
                this.imageCount(model.getImageCount());
            }
            if (model.wasPropertyExplicitlySet("isPublic")) {
                this.isPublic(model.getIsPublic());
            }
            if (model.wasPropertyExplicitlySet("layerCount")) {
                this.layerCount(model.getLayerCount());
            }
            if (model.wasPropertyExplicitlySet("layersSizeInBytes")) {
                this.layersSizeInBytes(model.getLayersSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("billableSizeInGBs")) {
                this.billableSizeInGBs(model.getBillableSizeInGBs());
            }
            return this;
        }
    }
}

