/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.audit.AuditAsync;
import com.oracle.bmc.audit.model.AuditEvent;
import com.oracle.bmc.audit.model.Configuration;
import com.oracle.bmc.audit.requests.GetConfigurationRequest;
import com.oracle.bmc.audit.requests.ListEventsRequest;
import com.oracle.bmc.audit.requests.UpdateConfigurationRequest;
import com.oracle.bmc.audit.responses.GetConfigurationResponse;
import com.oracle.bmc.audit.responses.ListEventsResponse;
import com.oracle.bmc.audit.responses.UpdateConfigurationResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditAsyncClient
extends BaseAsyncClient
implements AuditAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AUDIT").serviceEndpointPrefix("audit").serviceEndpointTemplate("https://audit.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AuditAsyncClient.class);

    AuditAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request, AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetConfigurationResponse::builder).logger(LOG, "getConfiguration").serviceDetails("Audit", "GetConfiguration", "https://docs.oracle.com/iaas/api/#/en/audit/20190901/Configuration/GetConfiguration").method(Method.GET).requestBuilder(GetConfigurationRequest::builder).basePath("/20190901").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).handleBody(Configuration.class, GetConfigurationResponse.Builder::configuration).callAsync(handler);
    }

    @Override
    public Future<ListEventsResponse> listEvents(ListEventsRequest request, AsyncHandler<ListEventsRequest, ListEventsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, ListEventsResponse::builder).logger(LOG, "listEvents").serviceDetails("Audit", "ListEvents", "https://docs.oracle.com/iaas/api/#/en/audit/20190901/AuditEvent/ListEvents").method(Method.GET).requestBuilder(ListEventsRequest::builder).basePath("/20190901").appendPathParam("auditEvents").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AuditEvent.class, ListEventsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListEventsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListEventsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request, AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getUpdateConfigurationDetails(), "updateConfigurationDetails is required");
        return this.clientCall(request, UpdateConfigurationResponse::builder).logger(LOG, "updateConfiguration").serviceDetails("Audit", "UpdateConfiguration", "https://docs.oracle.com/iaas/api/#/en/audit/20190901/Configuration/UpdateConfiguration").method(Method.PUT).requestBuilder(UpdateConfigurationRequest::builder).basePath("/20190901").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).hasBody().handleResponseHeaderString("opc-request-id", UpdateConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateConfigurationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public AuditAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AuditAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AuditAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AuditAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AuditAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AuditAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AuditAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AuditAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AuditAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AuditAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AuditAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AuditAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AuditAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

