/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListEventsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date startTime;
    private Date endTime;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).startTime(this.startTime).endTime(this.endTime).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",startTime=").append(String.valueOf(this.startTime));
        sb.append(",endTime=").append(String.valueOf(this.endTime));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListEventsRequest)) {
            return false;
        }
        ListEventsRequest other = (ListEventsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListEventsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date startTime = null;
        private Date endTime = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListEventsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListEventsRequest build() {
            ListEventsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListEventsRequest buildWithoutInvocationCallback() {
            ListEventsRequest request = new ListEventsRequest();
            request.compartmentId = this.compartmentId;
            request.startTime = this.startTime;
            request.endTime = this.endTime;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

