/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.audit.model.Data;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuditEvent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="eventType")
    private final String eventType;
    @JsonProperty(value="cloudEventsVersion")
    private final String cloudEventsVersion;
    @JsonProperty(value="eventTypeVersion")
    private final String eventTypeVersion;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="eventId")
    private final String eventId;
    @JsonProperty(value="eventTime")
    private final Date eventTime;
    @JsonProperty(value="contentType")
    private final String contentType;
    @JsonProperty(value="data")
    private final Data data;

    @Deprecated
    @ConstructorProperties(value={"eventType", "cloudEventsVersion", "eventTypeVersion", "source", "eventId", "eventTime", "contentType", "data"})
    public AuditEvent(String eventType, String cloudEventsVersion, String eventTypeVersion, String source, String eventId, Date eventTime, String contentType, Data data) {
        this.eventType = eventType;
        this.cloudEventsVersion = cloudEventsVersion;
        this.eventTypeVersion = eventTypeVersion;
        this.source = source;
        this.eventId = eventId;
        this.eventTime = eventTime;
        this.contentType = contentType;
        this.data = data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getCloudEventsVersion() {
        return this.cloudEventsVersion;
    }

    public String getEventTypeVersion() {
        return this.eventTypeVersion;
    }

    public String getSource() {
        return this.source;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Data getData() {
        return this.data;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditEvent(");
        sb.append("super=").append(super.toString());
        sb.append("eventType=").append(String.valueOf(this.eventType));
        sb.append(", cloudEventsVersion=").append(String.valueOf(this.cloudEventsVersion));
        sb.append(", eventTypeVersion=").append(String.valueOf(this.eventTypeVersion));
        sb.append(", source=").append(String.valueOf(this.source));
        sb.append(", eventId=").append(String.valueOf(this.eventId));
        sb.append(", eventTime=").append(String.valueOf(this.eventTime));
        sb.append(", contentType=").append(String.valueOf(this.contentType));
        sb.append(", data=").append(String.valueOf((Object)this.data));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent)((Object)o);
        return Objects.equals(this.eventType, other.eventType) && Objects.equals(this.cloudEventsVersion, other.cloudEventsVersion) && Objects.equals(this.eventTypeVersion, other.eventTypeVersion) && Objects.equals(this.source, other.source) && Objects.equals(this.eventId, other.eventId) && Objects.equals(this.eventTime, other.eventTime) && Objects.equals(this.contentType, other.contentType) && Objects.equals((Object)this.data, (Object)other.data) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.eventType == null ? 43 : this.eventType.hashCode());
        result = result * 59 + (this.cloudEventsVersion == null ? 43 : this.cloudEventsVersion.hashCode());
        result = result * 59 + (this.eventTypeVersion == null ? 43 : this.eventTypeVersion.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.eventId == null ? 43 : this.eventId.hashCode());
        result = result * 59 + (this.eventTime == null ? 43 : this.eventTime.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.data == null ? 43 : this.data.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="eventType")
        private String eventType;
        @JsonProperty(value="cloudEventsVersion")
        private String cloudEventsVersion;
        @JsonProperty(value="eventTypeVersion")
        private String eventTypeVersion;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="eventId")
        private String eventId;
        @JsonProperty(value="eventTime")
        private Date eventTime;
        @JsonProperty(value="contentType")
        private String contentType;
        @JsonProperty(value="data")
        private Data data;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            this.__explicitlySet__.add("eventType");
            return this;
        }

        public Builder cloudEventsVersion(String cloudEventsVersion) {
            this.cloudEventsVersion = cloudEventsVersion;
            this.__explicitlySet__.add("cloudEventsVersion");
            return this;
        }

        public Builder eventTypeVersion(String eventTypeVersion) {
            this.eventTypeVersion = eventTypeVersion;
            this.__explicitlySet__.add("eventTypeVersion");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            this.__explicitlySet__.add("eventId");
            return this;
        }

        public Builder eventTime(Date eventTime) {
            this.eventTime = eventTime;
            this.__explicitlySet__.add("eventTime");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.__explicitlySet__.add("contentType");
            return this;
        }

        public Builder data(Data data) {
            this.data = data;
            this.__explicitlySet__.add("data");
            return this;
        }

        public AuditEvent build() {
            AuditEvent model = new AuditEvent(this.eventType, this.cloudEventsVersion, this.eventTypeVersion, this.source, this.eventId, this.eventTime, this.contentType, this.data);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuditEvent model) {
            if (model.wasPropertyExplicitlySet("eventType")) {
                this.eventType(model.getEventType());
            }
            if (model.wasPropertyExplicitlySet("cloudEventsVersion")) {
                this.cloudEventsVersion(model.getCloudEventsVersion());
            }
            if (model.wasPropertyExplicitlySet("eventTypeVersion")) {
                this.eventTypeVersion(model.getEventTypeVersion());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("eventId")) {
                this.eventId(model.getEventId());
            }
            if (model.wasPropertyExplicitlySet("eventTime")) {
                this.eventTime(model.getEventTime());
            }
            if (model.wasPropertyExplicitlySet("contentType")) {
                this.contentType(model.getContentType());
            }
            if (model.wasPropertyExplicitlySet("data")) {
                this.data(model.getData());
            }
            return this;
        }
    }
}

