/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.autoscaling.AutoScalingAsync;
import com.oracle.bmc.autoscaling.internal.http.ChangeAutoScalingConfigurationCompartmentConverter;
import com.oracle.bmc.autoscaling.internal.http.CreateAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.CreateAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.DeleteAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.DeleteAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.GetAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.GetAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.internal.http.ListAutoScalingConfigurationsConverter;
import com.oracle.bmc.autoscaling.internal.http.ListAutoScalingPoliciesConverter;
import com.oracle.bmc.autoscaling.internal.http.UpdateAutoScalingConfigurationConverter;
import com.oracle.bmc.autoscaling.internal.http.UpdateAutoScalingPolicyConverter;
import com.oracle.bmc.autoscaling.requests.ChangeAutoScalingConfigurationCompartmentRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingPoliciesRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.responses.ChangeAutoScalingConfigurationCompartmentResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingPoliciesResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingAsyncClient
implements AutoScalingAsync {
    private static final Logger LOG = LoggerFactory.getLogger(AutoScalingAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AUTOSCALING").serviceEndpointPrefix("").serviceEndpointTemplate("https://autoscaling.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public AutoScalingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AutoScalingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AutoScalingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public AutoScalingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeAutoScalingConfigurationCompartmentResponse> changeAutoScalingConfigurationCompartment(ChangeAutoScalingConfigurationCompartmentRequest request, AsyncHandler<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse> handler) {
        LOG.trace("Called async changeAutoScalingConfigurationCompartment");
        ChangeAutoScalingConfigurationCompartmentRequest interceptedRequest = ChangeAutoScalingConfigurationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAutoScalingConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAutoScalingConfigurationCompartmentResponse> transformer = ChangeAutoScalingConfigurationCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeAutoScalingConfigurationCompartmentRequest, ChangeAutoScalingConfigurationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAutoScalingConfigurationResponse> createAutoScalingConfiguration(CreateAutoScalingConfigurationRequest request, AsyncHandler<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async createAutoScalingConfiguration");
        CreateAutoScalingConfigurationRequest interceptedRequest = CreateAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutoScalingConfigurationResponse> transformer = CreateAutoScalingConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAutoScalingConfigurationRequest, CreateAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAutoScalingPolicyResponse> createAutoScalingPolicy(CreateAutoScalingPolicyRequest request, AsyncHandler<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async createAutoScalingPolicy");
        CreateAutoScalingPolicyRequest interceptedRequest = CreateAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutoScalingPolicyResponse> transformer = CreateAutoScalingPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAutoScalingPolicyRequest, CreateAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAutoScalingConfigurationResponse> deleteAutoScalingConfiguration(DeleteAutoScalingConfigurationRequest request, AsyncHandler<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async deleteAutoScalingConfiguration");
        DeleteAutoScalingConfigurationRequest interceptedRequest = DeleteAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAutoScalingConfigurationResponse> transformer = DeleteAutoScalingConfigurationConverter.fromResponse();
        AsyncHandler<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAutoScalingConfigurationRequest, DeleteAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAutoScalingPolicyResponse> deleteAutoScalingPolicy(DeleteAutoScalingPolicyRequest request, AsyncHandler<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async deleteAutoScalingPolicy");
        DeleteAutoScalingPolicyRequest interceptedRequest = DeleteAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAutoScalingPolicyResponse> transformer = DeleteAutoScalingPolicyConverter.fromResponse();
        AsyncHandler<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAutoScalingPolicyRequest, DeleteAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAutoScalingConfigurationResponse> getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async getAutoScalingConfiguration");
        GetAutoScalingConfigurationRequest interceptedRequest = GetAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutoScalingConfigurationResponse> transformer = GetAutoScalingConfigurationConverter.fromResponse();
        AsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAutoScalingPolicyResponse> getAutoScalingPolicy(GetAutoScalingPolicyRequest request, AsyncHandler<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async getAutoScalingPolicy");
        GetAutoScalingPolicyRequest interceptedRequest = GetAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutoScalingPolicyResponse> transformer = GetAutoScalingPolicyConverter.fromResponse();
        AsyncHandler<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAutoScalingPolicyRequest, GetAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request, AsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> handler) {
        LOG.trace("Called async listAutoScalingConfigurations");
        ListAutoScalingConfigurationsRequest interceptedRequest = ListAutoScalingConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutoScalingConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutoScalingConfigurationsResponse> transformer = ListAutoScalingConfigurationsConverter.fromResponse();
        AsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAutoScalingPoliciesResponse> listAutoScalingPolicies(ListAutoScalingPoliciesRequest request, AsyncHandler<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse> handler) {
        LOG.trace("Called async listAutoScalingPolicies");
        ListAutoScalingPoliciesRequest interceptedRequest = ListAutoScalingPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutoScalingPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutoScalingPoliciesResponse> transformer = ListAutoScalingPoliciesConverter.fromResponse();
        AsyncHandler<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAutoScalingPoliciesRequest, ListAutoScalingPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAutoScalingConfigurationResponse> updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request, AsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async updateAutoScalingConfiguration");
        UpdateAutoScalingConfigurationRequest interceptedRequest = UpdateAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutoScalingConfigurationResponse> transformer = UpdateAutoScalingConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAutoScalingPolicyResponse> updateAutoScalingPolicy(UpdateAutoScalingPolicyRequest request, AsyncHandler<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse> handler) {
        LOG.trace("Called async updateAutoScalingPolicy");
        UpdateAutoScalingPolicyRequest interceptedRequest = UpdateAutoScalingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutoScalingPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutoScalingPolicyResponse> transformer = UpdateAutoScalingPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAutoScalingPolicyRequest, UpdateAutoScalingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AutoScalingAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AutoScalingAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new AutoScalingAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

