/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingConfigurationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAutoScalingConfigurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteAutoScalingConfigurationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteAutoScalingConfigurationRequest interceptRequest(DeleteAutoScalingConfigurationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteAutoScalingConfigurationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("autoScalingConfigurations").path(HttpUtils.encodePathSegment((String)request.getAutoScalingConfigurationId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteAutoScalingConfigurationResponse> fromResponse() {
        Function<Response, DeleteAutoScalingConfigurationResponse> transformer = new Function<Response, DeleteAutoScalingConfigurationResponse>(){

            public DeleteAutoScalingConfigurationResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.autoscaling.responses.DeleteAutoScalingConfigurationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteAutoScalingConfigurationResponse.Builder builder = DeleteAutoScalingConfigurationResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteAutoScalingConfigurationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

