/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.autoscaling.AutoScaling;
import com.oracle.bmc.autoscaling.AutoScalingPaginators;
import com.oracle.bmc.autoscaling.model.AutoScalingConfiguration;
import com.oracle.bmc.autoscaling.model.AutoScalingConfigurationSummary;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicy;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicySummary;
import com.oracle.bmc.autoscaling.requests.ChangeAutoScalingConfigurationCompartmentRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.CreateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.DeleteAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.GetAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.autoscaling.requests.ListAutoScalingPoliciesRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.autoscaling.requests.UpdateAutoScalingPolicyRequest;
import com.oracle.bmc.autoscaling.responses.ChangeAutoScalingConfigurationCompartmentResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.CreateAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.DeleteAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.GetAutoScalingPolicyResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.autoscaling.responses.ListAutoScalingPoliciesResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.autoscaling.responses.UpdateAutoScalingPolicyResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingClient
extends BaseSyncClient
implements AutoScaling {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AUTOSCALING").serviceEndpointPrefix("").serviceEndpointTemplate("https://autoscaling.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AutoScalingClient.class);
    private final AutoScalingPaginators paginators = new AutoScalingPaginators(this);

    AutoScalingClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeAutoScalingConfigurationCompartmentResponse changeAutoScalingConfigurationCompartment(ChangeAutoScalingConfigurationCompartmentRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCompartmentDetails(), "changeCompartmentDetails is required");
        return (ChangeAutoScalingConfigurationCompartmentResponse)this.clientCall(request, ChangeAutoScalingConfigurationCompartmentResponse::builder).logger(LOG, "changeAutoScalingConfigurationCompartment").serviceDetails("AutoScaling", "ChangeAutoScalingConfigurationCompartment", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingConfiguration/ChangeAutoScalingConfigurationCompartment").method(Method.POST).requestBuilder(ChangeAutoScalingConfigurationCompartmentRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeAutoScalingConfigurationCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeAutoScalingConfigurationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAutoScalingConfigurationResponse createAutoScalingConfiguration(CreateAutoScalingConfigurationRequest request) {
        Objects.requireNonNull(request.getCreateAutoScalingConfigurationDetails(), "createAutoScalingConfigurationDetails is required");
        return (CreateAutoScalingConfigurationResponse)this.clientCall(request, CreateAutoScalingConfigurationResponse::builder).logger(LOG, "createAutoScalingConfiguration").serviceDetails("AutoScaling", "CreateAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingConfiguration/CreateAutoScalingConfiguration").method(Method.POST).requestBuilder(CreateAutoScalingConfigurationRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AutoScalingConfiguration.class, CreateAutoScalingConfigurationResponse.Builder::autoScalingConfiguration).handleResponseHeaderString("etag", CreateAutoScalingConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAutoScalingConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAutoScalingPolicyResponse createAutoScalingPolicy(CreateAutoScalingPolicyRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAutoScalingPolicyDetails(), "createAutoScalingPolicyDetails is required");
        return (CreateAutoScalingPolicyResponse)this.clientCall(request, CreateAutoScalingPolicyResponse::builder).logger(LOG, "createAutoScalingPolicy").serviceDetails("AutoScaling", "CreateAutoScalingPolicy", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingPolicy/CreateAutoScalingPolicy").method(Method.POST).requestBuilder(CreateAutoScalingPolicyRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("policies").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AutoScalingPolicy.class, CreateAutoScalingPolicyResponse.Builder::autoScalingPolicy).handleResponseHeaderString("etag", CreateAutoScalingPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAutoScalingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAutoScalingConfigurationResponse deleteAutoScalingConfiguration(DeleteAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        return (DeleteAutoScalingConfigurationResponse)this.clientCall(request, DeleteAutoScalingConfigurationResponse::builder).logger(LOG, "deleteAutoScalingConfiguration").serviceDetails("AutoScaling", "DeleteAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingConfiguration/DeleteAutoScalingConfiguration").method(Method.DELETE).requestBuilder(DeleteAutoScalingConfigurationRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAutoScalingConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAutoScalingPolicyResponse deleteAutoScalingPolicy(DeleteAutoScalingPolicyRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAutoScalingPolicyId(), (String)"autoScalingPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteAutoScalingPolicyResponse)this.clientCall(request, DeleteAutoScalingPolicyResponse::builder).logger(LOG, "deleteAutoScalingPolicy").serviceDetails("AutoScaling", "DeleteAutoScalingPolicy", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingPolicy/DeleteAutoScalingPolicy").method(Method.DELETE).requestBuilder(DeleteAutoScalingPolicyRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("policies").appendPathParam(request.getAutoScalingPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAutoScalingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAutoScalingConfigurationResponse getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        return (GetAutoScalingConfigurationResponse)this.clientCall(request, GetAutoScalingConfigurationResponse::builder).logger(LOG, "getAutoScalingConfiguration").serviceDetails("AutoScaling", "GetAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingConfiguration/GetAutoScalingConfiguration").method(Method.GET).requestBuilder(GetAutoScalingConfigurationRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AutoScalingConfiguration.class, GetAutoScalingConfigurationResponse.Builder::autoScalingConfiguration).handleResponseHeaderString("etag", GetAutoScalingConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAutoScalingConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAutoScalingPolicyResponse getAutoScalingPolicy(GetAutoScalingPolicyRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAutoScalingPolicyId(), (String)"autoScalingPolicyId must not be blank", (Object[])new Object[0]);
        return (GetAutoScalingPolicyResponse)this.clientCall(request, GetAutoScalingPolicyResponse::builder).logger(LOG, "getAutoScalingPolicy").serviceDetails("AutoScaling", "GetAutoScalingPolicy", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingPolicy/GetAutoScalingPolicy").method(Method.GET).requestBuilder(GetAutoScalingPolicyRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("policies").appendPathParam(request.getAutoScalingPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AutoScalingPolicy.class, GetAutoScalingPolicyResponse.Builder::autoScalingPolicy).handleResponseHeaderString("etag", GetAutoScalingPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAutoScalingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAutoScalingConfigurationsResponse listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAutoScalingConfigurationsResponse)this.clientCall(request, ListAutoScalingConfigurationsResponse::builder).logger(LOG, "listAutoScalingConfigurations").serviceDetails("AutoScaling", "ListAutoScalingConfigurations", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingConfigurationSummary/ListAutoScalingConfigurations").method(Method.GET).requestBuilder(ListAutoScalingConfigurationsRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AutoScalingConfigurationSummary.class, ListAutoScalingConfigurationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAutoScalingConfigurationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAutoScalingConfigurationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAutoScalingPoliciesResponse listAutoScalingPolicies(ListAutoScalingPoliciesRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        return (ListAutoScalingPoliciesResponse)this.clientCall(request, ListAutoScalingPoliciesResponse::builder).logger(LOG, "listAutoScalingPolicies").serviceDetails("AutoScaling", "ListAutoScalingPolicies", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingPolicySummary/ListAutoScalingPolicies").method(Method.GET).requestBuilder(ListAutoScalingPoliciesRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("policies").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AutoScalingPolicySummary.class, ListAutoScalingPoliciesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAutoScalingPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAutoScalingPoliciesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAutoScalingConfigurationResponse updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAutoScalingConfigurationDetails(), "updateAutoScalingConfigurationDetails is required");
        return (UpdateAutoScalingConfigurationResponse)this.clientCall(request, UpdateAutoScalingConfigurationResponse::builder).logger(LOG, "updateAutoScalingConfiguration").serviceDetails("AutoScaling", "UpdateAutoScalingConfiguration", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingConfiguration/UpdateAutoScalingConfiguration").method(Method.PUT).requestBuilder(UpdateAutoScalingConfigurationRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AutoScalingConfiguration.class, UpdateAutoScalingConfigurationResponse.Builder::autoScalingConfiguration).handleResponseHeaderString("etag", UpdateAutoScalingConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAutoScalingConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAutoScalingPolicyResponse updateAutoScalingPolicy(UpdateAutoScalingPolicyRequest request) {
        Validate.notBlank((String)request.getAutoScalingConfigurationId(), (String)"autoScalingConfigurationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAutoScalingPolicyId(), (String)"autoScalingPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAutoScalingPolicyDetails(), "updateAutoScalingPolicyDetails is required");
        return (UpdateAutoScalingPolicyResponse)this.clientCall(request, UpdateAutoScalingPolicyResponse::builder).logger(LOG, "updateAutoScalingPolicy").serviceDetails("AutoScaling", "UpdateAutoScalingPolicy", "https://docs.oracle.com/iaas/api/#/en/autoscaling/20181001/AutoScalingPolicy/UpdateAutoScalingPolicy").method(Method.PUT).requestBuilder(UpdateAutoScalingPolicyRequest::builder).basePath("/20181001").appendPathParam("autoScalingConfigurations").appendPathParam(request.getAutoScalingConfigurationId()).appendPathParam("policies").appendPathParam(request.getAutoScalingPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AutoScalingPolicy.class, UpdateAutoScalingPolicyResponse.Builder::autoScalingPolicy).handleResponseHeaderString("etag", UpdateAutoScalingPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAutoScalingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AutoScalingPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AutoScalingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AutoScalingClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AutoScalingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AutoScalingClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AutoScalingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AutoScalingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AutoScalingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AutoScalingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AutoScalingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AutoScalingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AutoScalingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AutoScalingClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "autoscaling";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"autoscaling");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AutoScalingClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AutoScalingClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

