/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.ShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddWorkerNodesDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="clusterAdminPassword")
    private final String clusterAdminPassword;
    @JsonProperty(value="numberOfWorkerNodes")
    private final Integer numberOfWorkerNodes;
    @JsonProperty(value="nodeType")
    private final NodeType nodeType;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="blockVolumeSizeInGBs")
    private final Long blockVolumeSizeInGBs;
    @JsonProperty(value="shapeConfig")
    private final ShapeConfigDetails shapeConfig;

    @Deprecated
    @ConstructorProperties(value={"clusterAdminPassword", "numberOfWorkerNodes", "nodeType", "shape", "blockVolumeSizeInGBs", "shapeConfig"})
    public AddWorkerNodesDetails(String clusterAdminPassword, Integer numberOfWorkerNodes, NodeType nodeType, String shape, Long blockVolumeSizeInGBs, ShapeConfigDetails shapeConfig) {
        this.clusterAdminPassword = clusterAdminPassword;
        this.numberOfWorkerNodes = numberOfWorkerNodes;
        this.nodeType = nodeType;
        this.shape = shape;
        this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
        this.shapeConfig = shapeConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getClusterAdminPassword() {
        return this.clusterAdminPassword;
    }

    public Integer getNumberOfWorkerNodes() {
        return this.numberOfWorkerNodes;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getShape() {
        return this.shape;
    }

    public Long getBlockVolumeSizeInGBs() {
        return this.blockVolumeSizeInGBs;
    }

    public ShapeConfigDetails getShapeConfig() {
        return this.shapeConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddWorkerNodesDetails(");
        sb.append("super=").append(super.toString());
        sb.append("clusterAdminPassword=").append("<redacted>");
        sb.append(", numberOfWorkerNodes=").append(String.valueOf(this.numberOfWorkerNodes));
        sb.append(", nodeType=").append(String.valueOf((Object)this.nodeType));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", blockVolumeSizeInGBs=").append(String.valueOf(this.blockVolumeSizeInGBs));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddWorkerNodesDetails)) {
            return false;
        }
        AddWorkerNodesDetails other = (AddWorkerNodesDetails)((Object)o);
        return Objects.equals(this.clusterAdminPassword, other.clusterAdminPassword) && Objects.equals(this.numberOfWorkerNodes, other.numberOfWorkerNodes) && Objects.equals((Object)this.nodeType, (Object)other.nodeType) && Objects.equals(this.shape, other.shape) && Objects.equals(this.blockVolumeSizeInGBs, other.blockVolumeSizeInGBs) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.clusterAdminPassword == null ? 43 : this.clusterAdminPassword.hashCode());
        result = result * 59 + (this.numberOfWorkerNodes == null ? 43 : this.numberOfWorkerNodes.hashCode());
        result = result * 59 + (this.nodeType == null ? 43 : this.nodeType.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.blockVolumeSizeInGBs == null ? 43 : this.blockVolumeSizeInGBs.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NodeType implements BmcEnum
    {
        Worker("WORKER"),
        ComputeOnlyWorker("COMPUTE_ONLY_WORKER"),
        Edge("EDGE"),
        KafkaBroker("KAFKA_BROKER");

        private final String value;
        private static Map<String, NodeType> map;

        private NodeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NodeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid NodeType: " + key);
        }

        static {
            map = new HashMap<String, NodeType>();
            for (NodeType v : NodeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clusterAdminPassword")
        private String clusterAdminPassword;
        @JsonProperty(value="numberOfWorkerNodes")
        private Integer numberOfWorkerNodes;
        @JsonProperty(value="nodeType")
        private NodeType nodeType;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="blockVolumeSizeInGBs")
        private Long blockVolumeSizeInGBs;
        @JsonProperty(value="shapeConfig")
        private ShapeConfigDetails shapeConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clusterAdminPassword(String clusterAdminPassword) {
            this.clusterAdminPassword = clusterAdminPassword;
            this.__explicitlySet__.add("clusterAdminPassword");
            return this;
        }

        public Builder numberOfWorkerNodes(Integer numberOfWorkerNodes) {
            this.numberOfWorkerNodes = numberOfWorkerNodes;
            this.__explicitlySet__.add("numberOfWorkerNodes");
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            this.__explicitlySet__.add("nodeType");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder blockVolumeSizeInGBs(Long blockVolumeSizeInGBs) {
            this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
            this.__explicitlySet__.add("blockVolumeSizeInGBs");
            return this;
        }

        public Builder shapeConfig(ShapeConfigDetails shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public AddWorkerNodesDetails build() {
            AddWorkerNodesDetails model = new AddWorkerNodesDetails(this.clusterAdminPassword, this.numberOfWorkerNodes, this.nodeType, this.shape, this.blockVolumeSizeInGBs, this.shapeConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddWorkerNodesDetails model) {
            if (model.wasPropertyExplicitlySet("clusterAdminPassword")) {
                this.clusterAdminPassword(model.getClusterAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("numberOfWorkerNodes")) {
                this.numberOfWorkerNodes(model.getNumberOfWorkerNodes());
            }
            if (model.wasPropertyExplicitlySet("nodeType")) {
                this.nodeType(model.getNodeType());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("blockVolumeSizeInGBs")) {
                this.blockVolumeSizeInGBs(model.getBlockVolumeSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            return this;
        }
    }
}

