/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OsPatchSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="osPatchVersion")
    private final String osPatchVersion;
    @JsonProperty(value="releaseDate")
    private final Date releaseDate;

    @Deprecated
    @ConstructorProperties(value={"osPatchVersion", "releaseDate"})
    public OsPatchSummary(String osPatchVersion, Date releaseDate) {
        this.osPatchVersion = osPatchVersion;
        this.releaseDate = releaseDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOsPatchVersion() {
        return this.osPatchVersion;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OsPatchSummary(");
        sb.append("super=").append(super.toString());
        sb.append("osPatchVersion=").append(String.valueOf(this.osPatchVersion));
        sb.append(", releaseDate=").append(String.valueOf(this.releaseDate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OsPatchSummary)) {
            return false;
        }
        OsPatchSummary other = (OsPatchSummary)((Object)o);
        return Objects.equals(this.osPatchVersion, other.osPatchVersion) && Objects.equals(this.releaseDate, other.releaseDate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.osPatchVersion == null ? 43 : this.osPatchVersion.hashCode());
        result = result * 59 + (this.releaseDate == null ? 43 : this.releaseDate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="osPatchVersion")
        private String osPatchVersion;
        @JsonProperty(value="releaseDate")
        private Date releaseDate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder osPatchVersion(String osPatchVersion) {
            this.osPatchVersion = osPatchVersion;
            this.__explicitlySet__.add("osPatchVersion");
            return this;
        }

        public Builder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.__explicitlySet__.add("releaseDate");
            return this;
        }

        public OsPatchSummary build() {
            OsPatchSummary model = new OsPatchSummary(this.osPatchVersion, this.releaseDate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OsPatchSummary model) {
            if (model.wasPropertyExplicitlySet("osPatchVersion")) {
                this.osPatchVersion(model.getOsPatchVersion());
            }
            if (model.wasPropertyExplicitlySet("releaseDate")) {
                this.releaseDate(model.getReleaseDate());
            }
            return this;
        }
    }
}

