/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum Service implements BmcEnum
{
    Zookeeper("ZOOKEEPER"),
    Ams("AMS"),
    Hdfs("HDFS"),
    Yarn("YARN"),
    Mapreduce("MAPREDUCE"),
    Oozie("OOZIE"),
    Hbase("HBASE"),
    Spark("SPARK"),
    Hive("HIVE"),
    Kafka("KAFKA"),
    Flink("FLINK"),
    Registry("REGISTRY");

    private final String value;
    private static Map<String, Service> map;

    private Service(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static Service create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid Service: " + key);
    }

    static {
        map = new HashMap<String, Service>();
        for (Service v : Service.values()) {
            map.put(v.getValue(), v);
        }
    }
}

