/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.model.AutoScalingConfiguration;
import com.oracle.bmc.bds.model.BdsApiKey;
import com.oracle.bmc.bds.model.BdsInstance;
import com.oracle.bmc.bds.model.BdsMetastoreConfiguration;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsApiKeyRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsApiKeyResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class BdsWaiters {
    private final ExecutorService executorService;
    private final Bds client;

    public BdsWaiters(ExecutorService executorService, Bds client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutoScalingConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(BmcGenericWaiter waiter, GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState ... targetStates) {
        final HashSet<AutoScalingConfiguration.LifecycleState> targetStatesSet = new HashSet<AutoScalingConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>(){

            @Override
            public GetAutoScalingConfigurationResponse apply(GetAutoScalingConfigurationRequest request) {
                return BdsWaiters.this.client.getAutoScalingConfiguration(request);
            }
        }, (Predicate)new Predicate<GetAutoScalingConfigurationResponse>(){

            @Override
            public boolean test(GetAutoScalingConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getAutoScalingConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutoScalingConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(GetBdsApiKeyRequest request, BdsApiKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsApiKey(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(GetBdsApiKeyRequest request, BdsApiKey.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsApiKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(GetBdsApiKeyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsApiKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsApiKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(BmcGenericWaiter waiter, GetBdsApiKeyRequest request, BdsApiKey.LifecycleState ... targetStates) {
        final HashSet<BdsApiKey.LifecycleState> targetStatesSet = new HashSet<BdsApiKey.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBdsApiKeyRequest, GetBdsApiKeyResponse>(){

            @Override
            public GetBdsApiKeyResponse apply(GetBdsApiKeyRequest request) {
                return BdsWaiters.this.client.getBdsApiKey(request);
            }
        }, (Predicate)new Predicate<GetBdsApiKeyResponse>(){

            @Override
            public boolean test(GetBdsApiKeyResponse response) {
                return targetStatesSet.contains((Object)response.getBdsApiKey().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsApiKey.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, BdsInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, BdsInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(BmcGenericWaiter waiter, GetBdsInstanceRequest request, BdsInstance.LifecycleState ... targetStates) {
        final HashSet<BdsInstance.LifecycleState> targetStatesSet = new HashSet<BdsInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBdsInstanceRequest, GetBdsInstanceResponse>(){

            @Override
            public GetBdsInstanceResponse apply(GetBdsInstanceRequest request) {
                return BdsWaiters.this.client.getBdsInstance(request);
            }
        }, (Predicate)new Predicate<GetBdsInstanceResponse>(){

            @Override
            public boolean test(GetBdsInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getBdsInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request, BdsMetastoreConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsMetastoreConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request, BdsMetastoreConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsMetastoreConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsMetastoreConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsMetastoreConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(BmcGenericWaiter waiter, GetBdsMetastoreConfigurationRequest request, BdsMetastoreConfiguration.LifecycleState ... targetStates) {
        final HashSet<BdsMetastoreConfiguration.LifecycleState> targetStatesSet = new HashSet<BdsMetastoreConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse>(){

            @Override
            public GetBdsMetastoreConfigurationResponse apply(GetBdsMetastoreConfigurationRequest request) {
                return BdsWaiters.this.client.getBdsMetastoreConfiguration(request);
            }
        }, (Predicate)new Predicate<GetBdsMetastoreConfigurationResponse>(){

            @Override
            public boolean test(GetBdsMetastoreConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getBdsMetastoreConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsMetastoreConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return BdsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

