/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.BdsInstance;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BdsInstanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final BdsInstance.LifecycleState lifecycleState;
    @JsonProperty(value="numberOfNodes")
    private final Integer numberOfNodes;
    @JsonProperty(value="numberOfNodesRequiringMaintenanceReboot")
    private final Integer numberOfNodesRequiringMaintenanceReboot;
    @JsonProperty(value="clusterVersion")
    private final BdsInstance.ClusterVersion clusterVersion;
    @JsonProperty(value="isHighAvailability")
    private final Boolean isHighAvailability;
    @JsonProperty(value="isSecure")
    private final Boolean isSecure;
    @JsonProperty(value="isCloudSqlConfigured")
    private final Boolean isCloudSqlConfigured;
    @JsonProperty(value="isKafkaConfigured")
    private final Boolean isKafkaConfigured;
    @JsonProperty(value="clusterProfile")
    private final BdsInstance.ClusterProfile clusterProfile;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "lifecycleState", "numberOfNodes", "numberOfNodesRequiringMaintenanceReboot", "clusterVersion", "isHighAvailability", "isSecure", "isCloudSqlConfigured", "isKafkaConfigured", "clusterProfile", "timeCreated", "freeformTags", "definedTags"})
    public BdsInstanceSummary(String id, String compartmentId, String displayName, BdsInstance.LifecycleState lifecycleState, Integer numberOfNodes, Integer numberOfNodesRequiringMaintenanceReboot, BdsInstance.ClusterVersion clusterVersion, Boolean isHighAvailability, Boolean isSecure, Boolean isCloudSqlConfigured, Boolean isKafkaConfigured, BdsInstance.ClusterProfile clusterProfile, Date timeCreated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.numberOfNodes = numberOfNodes;
        this.numberOfNodesRequiringMaintenanceReboot = numberOfNodesRequiringMaintenanceReboot;
        this.clusterVersion = clusterVersion;
        this.isHighAvailability = isHighAvailability;
        this.isSecure = isSecure;
        this.isCloudSqlConfigured = isCloudSqlConfigured;
        this.isKafkaConfigured = isKafkaConfigured;
        this.clusterProfile = clusterProfile;
        this.timeCreated = timeCreated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BdsInstance.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public Integer getNumberOfNodesRequiringMaintenanceReboot() {
        return this.numberOfNodesRequiringMaintenanceReboot;
    }

    public BdsInstance.ClusterVersion getClusterVersion() {
        return this.clusterVersion;
    }

    public Boolean getIsHighAvailability() {
        return this.isHighAvailability;
    }

    public Boolean getIsSecure() {
        return this.isSecure;
    }

    public Boolean getIsCloudSqlConfigured() {
        return this.isCloudSqlConfigured;
    }

    public Boolean getIsKafkaConfigured() {
        return this.isKafkaConfigured;
    }

    public BdsInstance.ClusterProfile getClusterProfile() {
        return this.clusterProfile;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BdsInstanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", numberOfNodes=").append(String.valueOf(this.numberOfNodes));
        sb.append(", numberOfNodesRequiringMaintenanceReboot=").append(String.valueOf(this.numberOfNodesRequiringMaintenanceReboot));
        sb.append(", clusterVersion=").append(String.valueOf((Object)this.clusterVersion));
        sb.append(", isHighAvailability=").append(String.valueOf(this.isHighAvailability));
        sb.append(", isSecure=").append(String.valueOf(this.isSecure));
        sb.append(", isCloudSqlConfigured=").append(String.valueOf(this.isCloudSqlConfigured));
        sb.append(", isKafkaConfigured=").append(String.valueOf(this.isKafkaConfigured));
        sb.append(", clusterProfile=").append(String.valueOf((Object)this.clusterProfile));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BdsInstanceSummary)) {
            return false;
        }
        BdsInstanceSummary other = (BdsInstanceSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.numberOfNodes, other.numberOfNodes) && Objects.equals(this.numberOfNodesRequiringMaintenanceReboot, other.numberOfNodesRequiringMaintenanceReboot) && Objects.equals((Object)this.clusterVersion, (Object)other.clusterVersion) && Objects.equals(this.isHighAvailability, other.isHighAvailability) && Objects.equals(this.isSecure, other.isSecure) && Objects.equals(this.isCloudSqlConfigured, other.isCloudSqlConfigured) && Objects.equals(this.isKafkaConfigured, other.isKafkaConfigured) && Objects.equals((Object)this.clusterProfile, (Object)other.clusterProfile) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.numberOfNodes == null ? 43 : this.numberOfNodes.hashCode());
        result = result * 59 + (this.numberOfNodesRequiringMaintenanceReboot == null ? 43 : this.numberOfNodesRequiringMaintenanceReboot.hashCode());
        result = result * 59 + (this.clusterVersion == null ? 43 : this.clusterVersion.hashCode());
        result = result * 59 + (this.isHighAvailability == null ? 43 : this.isHighAvailability.hashCode());
        result = result * 59 + (this.isSecure == null ? 43 : this.isSecure.hashCode());
        result = result * 59 + (this.isCloudSqlConfigured == null ? 43 : this.isCloudSqlConfigured.hashCode());
        result = result * 59 + (this.isKafkaConfigured == null ? 43 : this.isKafkaConfigured.hashCode());
        result = result * 59 + (this.clusterProfile == null ? 43 : this.clusterProfile.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private BdsInstance.LifecycleState lifecycleState;
        @JsonProperty(value="numberOfNodes")
        private Integer numberOfNodes;
        @JsonProperty(value="numberOfNodesRequiringMaintenanceReboot")
        private Integer numberOfNodesRequiringMaintenanceReboot;
        @JsonProperty(value="clusterVersion")
        private BdsInstance.ClusterVersion clusterVersion;
        @JsonProperty(value="isHighAvailability")
        private Boolean isHighAvailability;
        @JsonProperty(value="isSecure")
        private Boolean isSecure;
        @JsonProperty(value="isCloudSqlConfigured")
        private Boolean isCloudSqlConfigured;
        @JsonProperty(value="isKafkaConfigured")
        private Boolean isKafkaConfigured;
        @JsonProperty(value="clusterProfile")
        private BdsInstance.ClusterProfile clusterProfile;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(BdsInstance.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            this.__explicitlySet__.add("numberOfNodes");
            return this;
        }

        public Builder numberOfNodesRequiringMaintenanceReboot(Integer numberOfNodesRequiringMaintenanceReboot) {
            this.numberOfNodesRequiringMaintenanceReboot = numberOfNodesRequiringMaintenanceReboot;
            this.__explicitlySet__.add("numberOfNodesRequiringMaintenanceReboot");
            return this;
        }

        public Builder clusterVersion(BdsInstance.ClusterVersion clusterVersion) {
            this.clusterVersion = clusterVersion;
            this.__explicitlySet__.add("clusterVersion");
            return this;
        }

        public Builder isHighAvailability(Boolean isHighAvailability) {
            this.isHighAvailability = isHighAvailability;
            this.__explicitlySet__.add("isHighAvailability");
            return this;
        }

        public Builder isSecure(Boolean isSecure) {
            this.isSecure = isSecure;
            this.__explicitlySet__.add("isSecure");
            return this;
        }

        public Builder isCloudSqlConfigured(Boolean isCloudSqlConfigured) {
            this.isCloudSqlConfigured = isCloudSqlConfigured;
            this.__explicitlySet__.add("isCloudSqlConfigured");
            return this;
        }

        public Builder isKafkaConfigured(Boolean isKafkaConfigured) {
            this.isKafkaConfigured = isKafkaConfigured;
            this.__explicitlySet__.add("isKafkaConfigured");
            return this;
        }

        public Builder clusterProfile(BdsInstance.ClusterProfile clusterProfile) {
            this.clusterProfile = clusterProfile;
            this.__explicitlySet__.add("clusterProfile");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public BdsInstanceSummary build() {
            BdsInstanceSummary model = new BdsInstanceSummary(this.id, this.compartmentId, this.displayName, this.lifecycleState, this.numberOfNodes, this.numberOfNodesRequiringMaintenanceReboot, this.clusterVersion, this.isHighAvailability, this.isSecure, this.isCloudSqlConfigured, this.isKafkaConfigured, this.clusterProfile, this.timeCreated, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BdsInstanceSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("numberOfNodes")) {
                this.numberOfNodes(model.getNumberOfNodes());
            }
            if (model.wasPropertyExplicitlySet("numberOfNodesRequiringMaintenanceReboot")) {
                this.numberOfNodesRequiringMaintenanceReboot(model.getNumberOfNodesRequiringMaintenanceReboot());
            }
            if (model.wasPropertyExplicitlySet("clusterVersion")) {
                this.clusterVersion(model.getClusterVersion());
            }
            if (model.wasPropertyExplicitlySet("isHighAvailability")) {
                this.isHighAvailability(model.getIsHighAvailability());
            }
            if (model.wasPropertyExplicitlySet("isSecure")) {
                this.isSecure(model.getIsSecure());
            }
            if (model.wasPropertyExplicitlySet("isCloudSqlConfigured")) {
                this.isCloudSqlConfigured(model.getIsCloudSqlConfigured());
            }
            if (model.wasPropertyExplicitlySet("isKafkaConfigured")) {
                this.isKafkaConfigured(model.getIsKafkaConfigured());
            }
            if (model.wasPropertyExplicitlySet("clusterProfile")) {
                this.clusterProfile(model.getClusterProfile());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

