/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.HostSpecificCertificateDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CertificateServiceInfoSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="service")
    private final Service service;
    @JsonProperty(value="serviceCertificateStatus")
    private final ServiceCertificateStatus serviceCertificateStatus;
    @JsonProperty(value="hostSpecificCertificateDetails")
    private final List<HostSpecificCertificateDetails> hostSpecificCertificateDetails;

    @Deprecated
    @ConstructorProperties(value={"service", "serviceCertificateStatus", "hostSpecificCertificateDetails"})
    public CertificateServiceInfoSummary(Service service, ServiceCertificateStatus serviceCertificateStatus, List<HostSpecificCertificateDetails> hostSpecificCertificateDetails) {
        this.service = service;
        this.serviceCertificateStatus = serviceCertificateStatus;
        this.hostSpecificCertificateDetails = hostSpecificCertificateDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Service getService() {
        return this.service;
    }

    public ServiceCertificateStatus getServiceCertificateStatus() {
        return this.serviceCertificateStatus;
    }

    public List<HostSpecificCertificateDetails> getHostSpecificCertificateDetails() {
        return this.hostSpecificCertificateDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateServiceInfoSummary(");
        sb.append("super=").append(super.toString());
        sb.append("service=").append(String.valueOf((Object)this.service));
        sb.append(", serviceCertificateStatus=").append(String.valueOf((Object)this.serviceCertificateStatus));
        sb.append(", hostSpecificCertificateDetails=").append(String.valueOf(this.hostSpecificCertificateDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateServiceInfoSummary)) {
            return false;
        }
        CertificateServiceInfoSummary other = (CertificateServiceInfoSummary)((Object)o);
        return Objects.equals((Object)this.service, (Object)other.service) && Objects.equals((Object)this.serviceCertificateStatus, (Object)other.serviceCertificateStatus) && Objects.equals(this.hostSpecificCertificateDetails, other.hostSpecificCertificateDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.serviceCertificateStatus == null ? 43 : this.serviceCertificateStatus.hashCode());
        result = result * 59 + (this.hostSpecificCertificateDetails == null ? 43 : this.hostSpecificCertificateDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ServiceCertificateStatus implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ServiceCertificateStatus> map;

        private ServiceCertificateStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServiceCertificateStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ServiceCertificateStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ServiceCertificateStatus.class);
            map = new HashMap<String, ServiceCertificateStatus>();
            for (ServiceCertificateStatus v : ServiceCertificateStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Service implements BmcEnum
    {
        Zookeeper("ZOOKEEPER"),
        Ams("AMS"),
        Hdfs("HDFS"),
        Yarn("YARN"),
        Mapreduce("MAPREDUCE"),
        Oozie("OOZIE"),
        Hbase("HBASE"),
        Spark("SPARK"),
        Hive("HIVE"),
        Kafka("KAFKA"),
        Flink("FLINK"),
        Registry("REGISTRY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Service> map;

        private Service(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Service create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Service', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Service.class);
            map = new HashMap<String, Service>();
            for (Service v : Service.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="service")
        private Service service;
        @JsonProperty(value="serviceCertificateStatus")
        private ServiceCertificateStatus serviceCertificateStatus;
        @JsonProperty(value="hostSpecificCertificateDetails")
        private List<HostSpecificCertificateDetails> hostSpecificCertificateDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder service(Service service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder serviceCertificateStatus(ServiceCertificateStatus serviceCertificateStatus) {
            this.serviceCertificateStatus = serviceCertificateStatus;
            this.__explicitlySet__.add("serviceCertificateStatus");
            return this;
        }

        public Builder hostSpecificCertificateDetails(List<HostSpecificCertificateDetails> hostSpecificCertificateDetails) {
            this.hostSpecificCertificateDetails = hostSpecificCertificateDetails;
            this.__explicitlySet__.add("hostSpecificCertificateDetails");
            return this;
        }

        public CertificateServiceInfoSummary build() {
            CertificateServiceInfoSummary model = new CertificateServiceInfoSummary(this.service, this.serviceCertificateStatus, this.hostSpecificCertificateDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CertificateServiceInfoSummary model) {
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("serviceCertificateStatus")) {
                this.serviceCertificateStatus(model.getServiceCertificateStatus());
            }
            if (model.wasPropertyExplicitlySet("hostSpecificCertificateDetails")) {
                this.hostSpecificCertificateDetails(model.getHostSpecificCertificateDetails());
            }
            return this;
        }
    }
}

