/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyMetricRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricBasedVerticalScaleDownConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metric")
    private final AutoScalePolicyMetricRule metric;
    @JsonProperty(value="minOcpusPerNode")
    private final Integer minOcpusPerNode;
    @JsonProperty(value="minMemoryPerNode")
    private final Integer minMemoryPerNode;
    @JsonProperty(value="ocpuStepSize")
    private final Integer ocpuStepSize;
    @JsonProperty(value="memoryStepSize")
    private final Integer memoryStepSize;

    @Deprecated
    @ConstructorProperties(value={"metric", "minOcpusPerNode", "minMemoryPerNode", "ocpuStepSize", "memoryStepSize"})
    public MetricBasedVerticalScaleDownConfig(AutoScalePolicyMetricRule metric, Integer minOcpusPerNode, Integer minMemoryPerNode, Integer ocpuStepSize, Integer memoryStepSize) {
        this.metric = metric;
        this.minOcpusPerNode = minOcpusPerNode;
        this.minMemoryPerNode = minMemoryPerNode;
        this.ocpuStepSize = ocpuStepSize;
        this.memoryStepSize = memoryStepSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AutoScalePolicyMetricRule getMetric() {
        return this.metric;
    }

    public Integer getMinOcpusPerNode() {
        return this.minOcpusPerNode;
    }

    public Integer getMinMemoryPerNode() {
        return this.minMemoryPerNode;
    }

    public Integer getOcpuStepSize() {
        return this.ocpuStepSize;
    }

    public Integer getMemoryStepSize() {
        return this.memoryStepSize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricBasedVerticalScaleDownConfig(");
        sb.append("super=").append(super.toString());
        sb.append("metric=").append(String.valueOf((Object)this.metric));
        sb.append(", minOcpusPerNode=").append(String.valueOf(this.minOcpusPerNode));
        sb.append(", minMemoryPerNode=").append(String.valueOf(this.minMemoryPerNode));
        sb.append(", ocpuStepSize=").append(String.valueOf(this.ocpuStepSize));
        sb.append(", memoryStepSize=").append(String.valueOf(this.memoryStepSize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricBasedVerticalScaleDownConfig)) {
            return false;
        }
        MetricBasedVerticalScaleDownConfig other = (MetricBasedVerticalScaleDownConfig)((Object)o);
        return Objects.equals((Object)this.metric, (Object)other.metric) && Objects.equals(this.minOcpusPerNode, other.minOcpusPerNode) && Objects.equals(this.minMemoryPerNode, other.minMemoryPerNode) && Objects.equals(this.ocpuStepSize, other.ocpuStepSize) && Objects.equals(this.memoryStepSize, other.memoryStepSize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metric == null ? 43 : this.metric.hashCode());
        result = result * 59 + (this.minOcpusPerNode == null ? 43 : this.minOcpusPerNode.hashCode());
        result = result * 59 + (this.minMemoryPerNode == null ? 43 : this.minMemoryPerNode.hashCode());
        result = result * 59 + (this.ocpuStepSize == null ? 43 : this.ocpuStepSize.hashCode());
        result = result * 59 + (this.memoryStepSize == null ? 43 : this.memoryStepSize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metric")
        private AutoScalePolicyMetricRule metric;
        @JsonProperty(value="minOcpusPerNode")
        private Integer minOcpusPerNode;
        @JsonProperty(value="minMemoryPerNode")
        private Integer minMemoryPerNode;
        @JsonProperty(value="ocpuStepSize")
        private Integer ocpuStepSize;
        @JsonProperty(value="memoryStepSize")
        private Integer memoryStepSize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metric(AutoScalePolicyMetricRule metric) {
            this.metric = metric;
            this.__explicitlySet__.add("metric");
            return this;
        }

        public Builder minOcpusPerNode(Integer minOcpusPerNode) {
            this.minOcpusPerNode = minOcpusPerNode;
            this.__explicitlySet__.add("minOcpusPerNode");
            return this;
        }

        public Builder minMemoryPerNode(Integer minMemoryPerNode) {
            this.minMemoryPerNode = minMemoryPerNode;
            this.__explicitlySet__.add("minMemoryPerNode");
            return this;
        }

        public Builder ocpuStepSize(Integer ocpuStepSize) {
            this.ocpuStepSize = ocpuStepSize;
            this.__explicitlySet__.add("ocpuStepSize");
            return this;
        }

        public Builder memoryStepSize(Integer memoryStepSize) {
            this.memoryStepSize = memoryStepSize;
            this.__explicitlySet__.add("memoryStepSize");
            return this;
        }

        public MetricBasedVerticalScaleDownConfig build() {
            MetricBasedVerticalScaleDownConfig model = new MetricBasedVerticalScaleDownConfig(this.metric, this.minOcpusPerNode, this.minMemoryPerNode, this.ocpuStepSize, this.memoryStepSize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricBasedVerticalScaleDownConfig model) {
            if (model.wasPropertyExplicitlySet("metric")) {
                this.metric(model.getMetric());
            }
            if (model.wasPropertyExplicitlySet("minOcpusPerNode")) {
                this.minOcpusPerNode(model.getMinOcpusPerNode());
            }
            if (model.wasPropertyExplicitlySet("minMemoryPerNode")) {
                this.minMemoryPerNode(model.getMinMemoryPerNode());
            }
            if (model.wasPropertyExplicitlySet("ocpuStepSize")) {
                this.ocpuStepSize(model.getOcpuStepSize());
            }
            if (model.wasPropertyExplicitlySet("memoryStepSize")) {
                this.memoryStepSize(model.getMemoryStepSize());
            }
            return this;
        }
    }
}

