/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TimeAndVerticalScalingConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeRecurrence")
    private final String timeRecurrence;
    @JsonProperty(value="targetShape")
    private final String targetShape;
    @JsonProperty(value="targetOcpusPerNode")
    private final Integer targetOcpusPerNode;
    @JsonProperty(value="targetMemoryPerNode")
    private final Integer targetMemoryPerNode;

    @Deprecated
    @ConstructorProperties(value={"timeRecurrence", "targetShape", "targetOcpusPerNode", "targetMemoryPerNode"})
    public TimeAndVerticalScalingConfig(String timeRecurrence, String targetShape, Integer targetOcpusPerNode, Integer targetMemoryPerNode) {
        this.timeRecurrence = timeRecurrence;
        this.targetShape = targetShape;
        this.targetOcpusPerNode = targetOcpusPerNode;
        this.targetMemoryPerNode = targetMemoryPerNode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTimeRecurrence() {
        return this.timeRecurrence;
    }

    public String getTargetShape() {
        return this.targetShape;
    }

    public Integer getTargetOcpusPerNode() {
        return this.targetOcpusPerNode;
    }

    public Integer getTargetMemoryPerNode() {
        return this.targetMemoryPerNode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeAndVerticalScalingConfig(");
        sb.append("super=").append(super.toString());
        sb.append("timeRecurrence=").append(String.valueOf(this.timeRecurrence));
        sb.append(", targetShape=").append(String.valueOf(this.targetShape));
        sb.append(", targetOcpusPerNode=").append(String.valueOf(this.targetOcpusPerNode));
        sb.append(", targetMemoryPerNode=").append(String.valueOf(this.targetMemoryPerNode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeAndVerticalScalingConfig)) {
            return false;
        }
        TimeAndVerticalScalingConfig other = (TimeAndVerticalScalingConfig)((Object)o);
        return Objects.equals(this.timeRecurrence, other.timeRecurrence) && Objects.equals(this.targetShape, other.targetShape) && Objects.equals(this.targetOcpusPerNode, other.targetOcpusPerNode) && Objects.equals(this.targetMemoryPerNode, other.targetMemoryPerNode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeRecurrence == null ? 43 : this.timeRecurrence.hashCode());
        result = result * 59 + (this.targetShape == null ? 43 : this.targetShape.hashCode());
        result = result * 59 + (this.targetOcpusPerNode == null ? 43 : this.targetOcpusPerNode.hashCode());
        result = result * 59 + (this.targetMemoryPerNode == null ? 43 : this.targetMemoryPerNode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeRecurrence")
        private String timeRecurrence;
        @JsonProperty(value="targetShape")
        private String targetShape;
        @JsonProperty(value="targetOcpusPerNode")
        private Integer targetOcpusPerNode;
        @JsonProperty(value="targetMemoryPerNode")
        private Integer targetMemoryPerNode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeRecurrence(String timeRecurrence) {
            this.timeRecurrence = timeRecurrence;
            this.__explicitlySet__.add("timeRecurrence");
            return this;
        }

        public Builder targetShape(String targetShape) {
            this.targetShape = targetShape;
            this.__explicitlySet__.add("targetShape");
            return this;
        }

        public Builder targetOcpusPerNode(Integer targetOcpusPerNode) {
            this.targetOcpusPerNode = targetOcpusPerNode;
            this.__explicitlySet__.add("targetOcpusPerNode");
            return this;
        }

        public Builder targetMemoryPerNode(Integer targetMemoryPerNode) {
            this.targetMemoryPerNode = targetMemoryPerNode;
            this.__explicitlySet__.add("targetMemoryPerNode");
            return this;
        }

        public TimeAndVerticalScalingConfig build() {
            TimeAndVerticalScalingConfig model = new TimeAndVerticalScalingConfig(this.timeRecurrence, this.targetShape, this.targetOcpusPerNode, this.targetMemoryPerNode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TimeAndVerticalScalingConfig model) {
            if (model.wasPropertyExplicitlySet("timeRecurrence")) {
                this.timeRecurrence(model.getTimeRecurrence());
            }
            if (model.wasPropertyExplicitlySet("targetShape")) {
                this.targetShape(model.getTargetShape());
            }
            if (model.wasPropertyExplicitlySet("targetOcpusPerNode")) {
                this.targetOcpusPerNode(model.getTargetOcpusPerNode());
            }
            if (model.wasPropertyExplicitlySet("targetMemoryPerNode")) {
                this.targetMemoryPerNode(model.getTargetMemoryPerNode());
            }
            return this;
        }
    }
}

