/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.bds.model.CreateBdsApiKeyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateBdsApiKeyRequest
extends BmcRequest<CreateBdsApiKeyDetails> {
    private String bdsInstanceId;
    private CreateBdsApiKeyDetails createBdsApiKeyDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public CreateBdsApiKeyDetails getCreateBdsApiKeyDetails() {
        return this.createBdsApiKeyDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateBdsApiKeyDetails getBody$() {
        return this.createBdsApiKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).createBdsApiKeyDetails(this.createBdsApiKeyDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",createBdsApiKeyDetails=").append(String.valueOf((Object)this.createBdsApiKeyDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBdsApiKeyRequest)) {
            return false;
        }
        CreateBdsApiKeyRequest other = (CreateBdsApiKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals((Object)this.createBdsApiKeyDetails, (Object)other.createBdsApiKeyDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.createBdsApiKeyDetails == null ? 43 : this.createBdsApiKeyDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBdsApiKeyRequest, CreateBdsApiKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private CreateBdsApiKeyDetails createBdsApiKeyDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder createBdsApiKeyDetails(CreateBdsApiKeyDetails createBdsApiKeyDetails) {
            this.createBdsApiKeyDetails = createBdsApiKeyDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBdsApiKeyRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.createBdsApiKeyDetails(o.getCreateBdsApiKeyDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBdsApiKeyRequest build() {
            CreateBdsApiKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBdsApiKeyDetails body) {
            this.createBdsApiKeyDetails(body);
            return this;
        }

        public CreateBdsApiKeyRequest buildWithoutInvocationCallback() {
            CreateBdsApiKeyRequest request = new CreateBdsApiKeyRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.createBdsApiKeyDetails = this.createBdsApiKeyDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

