/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.PatchingConfigs;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="patchingConfigStrategy")
@JsonFilter(value="explicitlySetFilter")
public final class BatchingBasedPatchingConfigs
extends PatchingConfigs {
    @JsonProperty(value="batchSize")
    private final Integer batchSize;
    @JsonProperty(value="waitTimeBetweenBatchInSeconds")
    private final Integer waitTimeBetweenBatchInSeconds;
    @JsonProperty(value="toleranceThresholdPerBatch")
    private final Integer toleranceThresholdPerBatch;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BatchingBasedPatchingConfigs(Integer batchSize, Integer waitTimeBetweenBatchInSeconds, Integer toleranceThresholdPerBatch) {
        this.batchSize = batchSize;
        this.waitTimeBetweenBatchInSeconds = waitTimeBetweenBatchInSeconds;
        this.toleranceThresholdPerBatch = toleranceThresholdPerBatch;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getWaitTimeBetweenBatchInSeconds() {
        return this.waitTimeBetweenBatchInSeconds;
    }

    public Integer getToleranceThresholdPerBatch() {
        return this.toleranceThresholdPerBatch;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchingBasedPatchingConfigs(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", batchSize=").append(String.valueOf(this.batchSize));
        sb.append(", waitTimeBetweenBatchInSeconds=").append(String.valueOf(this.waitTimeBetweenBatchInSeconds));
        sb.append(", toleranceThresholdPerBatch=").append(String.valueOf(this.toleranceThresholdPerBatch));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchingBasedPatchingConfigs)) {
            return false;
        }
        BatchingBasedPatchingConfigs other = (BatchingBasedPatchingConfigs)((Object)o);
        return Objects.equals(this.batchSize, other.batchSize) && Objects.equals(this.waitTimeBetweenBatchInSeconds, other.waitTimeBetweenBatchInSeconds) && Objects.equals(this.toleranceThresholdPerBatch, other.toleranceThresholdPerBatch) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.batchSize == null ? 43 : this.batchSize.hashCode());
        result = result * 59 + (this.waitTimeBetweenBatchInSeconds == null ? 43 : this.waitTimeBetweenBatchInSeconds.hashCode());
        result = result * 59 + (this.toleranceThresholdPerBatch == null ? 43 : this.toleranceThresholdPerBatch.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="batchSize")
        private Integer batchSize;
        @JsonProperty(value="waitTimeBetweenBatchInSeconds")
        private Integer waitTimeBetweenBatchInSeconds;
        @JsonProperty(value="toleranceThresholdPerBatch")
        private Integer toleranceThresholdPerBatch;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            this.__explicitlySet__.add("batchSize");
            return this;
        }

        public Builder waitTimeBetweenBatchInSeconds(Integer waitTimeBetweenBatchInSeconds) {
            this.waitTimeBetweenBatchInSeconds = waitTimeBetweenBatchInSeconds;
            this.__explicitlySet__.add("waitTimeBetweenBatchInSeconds");
            return this;
        }

        public Builder toleranceThresholdPerBatch(Integer toleranceThresholdPerBatch) {
            this.toleranceThresholdPerBatch = toleranceThresholdPerBatch;
            this.__explicitlySet__.add("toleranceThresholdPerBatch");
            return this;
        }

        public BatchingBasedPatchingConfigs build() {
            BatchingBasedPatchingConfigs model = new BatchingBasedPatchingConfigs(this.batchSize, this.waitTimeBetweenBatchInSeconds, this.toleranceThresholdPerBatch);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BatchingBasedPatchingConfigs model) {
            if (model.wasPropertyExplicitlySet("batchSize")) {
                this.batchSize(model.getBatchSize());
            }
            if (model.wasPropertyExplicitlySet("waitTimeBetweenBatchInSeconds")) {
                this.waitTimeBetweenBatchInSeconds(model.getWaitTimeBetweenBatchInSeconds());
            }
            if (model.wasPropertyExplicitlySet("toleranceThresholdPerBatch")) {
                this.toleranceThresholdPerBatch(model.getToleranceThresholdPerBatch());
            }
            return this;
        }
    }
}

