/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyMetricRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricBasedHorizontalScaleOutConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metric")
    private final AutoScalePolicyMetricRule metric;
    @JsonProperty(value="maxNodeCount")
    private final Integer maxNodeCount;
    @JsonProperty(value="stepSize")
    private final Integer stepSize;

    @Deprecated
    @ConstructorProperties(value={"metric", "maxNodeCount", "stepSize"})
    public MetricBasedHorizontalScaleOutConfig(AutoScalePolicyMetricRule metric, Integer maxNodeCount, Integer stepSize) {
        this.metric = metric;
        this.maxNodeCount = maxNodeCount;
        this.stepSize = stepSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AutoScalePolicyMetricRule getMetric() {
        return this.metric;
    }

    public Integer getMaxNodeCount() {
        return this.maxNodeCount;
    }

    public Integer getStepSize() {
        return this.stepSize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricBasedHorizontalScaleOutConfig(");
        sb.append("super=").append(super.toString());
        sb.append("metric=").append(String.valueOf((Object)this.metric));
        sb.append(", maxNodeCount=").append(String.valueOf(this.maxNodeCount));
        sb.append(", stepSize=").append(String.valueOf(this.stepSize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricBasedHorizontalScaleOutConfig)) {
            return false;
        }
        MetricBasedHorizontalScaleOutConfig other = (MetricBasedHorizontalScaleOutConfig)((Object)o);
        return Objects.equals((Object)this.metric, (Object)other.metric) && Objects.equals(this.maxNodeCount, other.maxNodeCount) && Objects.equals(this.stepSize, other.stepSize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metric == null ? 43 : this.metric.hashCode());
        result = result * 59 + (this.maxNodeCount == null ? 43 : this.maxNodeCount.hashCode());
        result = result * 59 + (this.stepSize == null ? 43 : this.stepSize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metric")
        private AutoScalePolicyMetricRule metric;
        @JsonProperty(value="maxNodeCount")
        private Integer maxNodeCount;
        @JsonProperty(value="stepSize")
        private Integer stepSize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metric(AutoScalePolicyMetricRule metric) {
            this.metric = metric;
            this.__explicitlySet__.add("metric");
            return this;
        }

        public Builder maxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
            this.__explicitlySet__.add("maxNodeCount");
            return this;
        }

        public Builder stepSize(Integer stepSize) {
            this.stepSize = stepSize;
            this.__explicitlySet__.add("stepSize");
            return this;
        }

        public MetricBasedHorizontalScaleOutConfig build() {
            MetricBasedHorizontalScaleOutConfig model = new MetricBasedHorizontalScaleOutConfig(this.metric, this.maxNodeCount, this.stepSize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricBasedHorizontalScaleOutConfig model) {
            if (model.wasPropertyExplicitlySet("metric")) {
                this.metric(model.getMetric());
            }
            if (model.wasPropertyExplicitlySet("maxNodeCount")) {
                this.maxNodeCount(model.getMaxNodeCount());
            }
            if (model.wasPropertyExplicitlySet("stepSize")) {
                this.stepSize(model.getStepSize());
            }
            return this;
        }
    }
}

