/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.VolumeAttachmentDetail;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Node
extends ExplicitlySetBmcModel {
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="nodeType")
    private final NodeType nodeType;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="attachedBlockVolumes")
    private final List<VolumeAttachmentDetail> attachedBlockVolumes;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="imageId")
    private final String imageId;
    @JsonProperty(value="sshFingerprint")
    private final String sshFingerprint;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="ocpus")
    private final Integer ocpus;
    @JsonProperty(value="memoryInGBs")
    private final Integer memoryInGBs;
    @JsonProperty(value="nvmes")
    private final Integer nvmes;
    @JsonProperty(value="localDisksTotalSizeInGBs")
    private final Double localDisksTotalSizeInGBs;
    @JsonProperty(value="timeMaintenanceRebootDue")
    private final Date timeMaintenanceRebootDue;
    @JsonProperty(value="osVersion")
    private final String osVersion;
    @JsonProperty(value="isRebootRequired")
    private final Boolean isRebootRequired;
    @JsonProperty(value="timeReplaced")
    private final Date timeReplaced;
    @JsonProperty(value="nodeBackupId")
    private final String nodeBackupId;

    @Deprecated
    @ConstructorProperties(value={"instanceId", "displayName", "lifecycleState", "nodeType", "shape", "attachedBlockVolumes", "subnetId", "ipAddress", "hostname", "imageId", "sshFingerprint", "availabilityDomain", "faultDomain", "timeCreated", "timeUpdated", "ocpus", "memoryInGBs", "nvmes", "localDisksTotalSizeInGBs", "timeMaintenanceRebootDue", "osVersion", "isRebootRequired", "timeReplaced", "nodeBackupId"})
    public Node(String instanceId, String displayName, LifecycleState lifecycleState, NodeType nodeType, String shape, List<VolumeAttachmentDetail> attachedBlockVolumes, String subnetId, String ipAddress, String hostname, String imageId, String sshFingerprint, String availabilityDomain, String faultDomain, Date timeCreated, Date timeUpdated, Integer ocpus, Integer memoryInGBs, Integer nvmes, Double localDisksTotalSizeInGBs, Date timeMaintenanceRebootDue, String osVersion, Boolean isRebootRequired, Date timeReplaced, String nodeBackupId) {
        this.instanceId = instanceId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.nodeType = nodeType;
        this.shape = shape;
        this.attachedBlockVolumes = attachedBlockVolumes;
        this.subnetId = subnetId;
        this.ipAddress = ipAddress;
        this.hostname = hostname;
        this.imageId = imageId;
        this.sshFingerprint = sshFingerprint;
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.ocpus = ocpus;
        this.memoryInGBs = memoryInGBs;
        this.nvmes = nvmes;
        this.localDisksTotalSizeInGBs = localDisksTotalSizeInGBs;
        this.timeMaintenanceRebootDue = timeMaintenanceRebootDue;
        this.osVersion = osVersion;
        this.isRebootRequired = isRebootRequired;
        this.timeReplaced = timeReplaced;
        this.nodeBackupId = nodeBackupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getShape() {
        return this.shape;
    }

    public List<VolumeAttachmentDetail> getAttachedBlockVolumes() {
        return this.attachedBlockVolumes;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getSshFingerprint() {
        return this.sshFingerprint;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Integer getOcpus() {
        return this.ocpus;
    }

    public Integer getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public Integer getNvmes() {
        return this.nvmes;
    }

    public Double getLocalDisksTotalSizeInGBs() {
        return this.localDisksTotalSizeInGBs;
    }

    public Date getTimeMaintenanceRebootDue() {
        return this.timeMaintenanceRebootDue;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Boolean getIsRebootRequired() {
        return this.isRebootRequired;
    }

    public Date getTimeReplaced() {
        return this.timeReplaced;
    }

    public String getNodeBackupId() {
        return this.nodeBackupId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node(");
        sb.append("super=").append(super.toString());
        sb.append("instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", nodeType=").append(String.valueOf((Object)this.nodeType));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", attachedBlockVolumes=").append(String.valueOf(this.attachedBlockVolumes));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(", sshFingerprint=").append(String.valueOf(this.sshFingerprint));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", nvmes=").append(String.valueOf(this.nvmes));
        sb.append(", localDisksTotalSizeInGBs=").append(String.valueOf(this.localDisksTotalSizeInGBs));
        sb.append(", timeMaintenanceRebootDue=").append(String.valueOf(this.timeMaintenanceRebootDue));
        sb.append(", osVersion=").append(String.valueOf(this.osVersion));
        sb.append(", isRebootRequired=").append(String.valueOf(this.isRebootRequired));
        sb.append(", timeReplaced=").append(String.valueOf(this.timeReplaced));
        sb.append(", nodeBackupId=").append(String.valueOf(this.nodeBackupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)((Object)o);
        return Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.nodeType, (Object)other.nodeType) && Objects.equals(this.shape, other.shape) && Objects.equals(this.attachedBlockVolumes, other.attachedBlockVolumes) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.imageId, other.imageId) && Objects.equals(this.sshFingerprint, other.sshFingerprint) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals(this.nvmes, other.nvmes) && Objects.equals(this.localDisksTotalSizeInGBs, other.localDisksTotalSizeInGBs) && Objects.equals(this.timeMaintenanceRebootDue, other.timeMaintenanceRebootDue) && Objects.equals(this.osVersion, other.osVersion) && Objects.equals(this.isRebootRequired, other.isRebootRequired) && Objects.equals(this.timeReplaced, other.timeReplaced) && Objects.equals(this.nodeBackupId, other.nodeBackupId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.nodeType == null ? 43 : this.nodeType.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.attachedBlockVolumes == null ? 43 : this.attachedBlockVolumes.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.sshFingerprint == null ? 43 : this.sshFingerprint.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.nvmes == null ? 43 : this.nvmes.hashCode());
        result = result * 59 + (this.localDisksTotalSizeInGBs == null ? 43 : this.localDisksTotalSizeInGBs.hashCode());
        result = result * 59 + (this.timeMaintenanceRebootDue == null ? 43 : this.timeMaintenanceRebootDue.hashCode());
        result = result * 59 + (this.osVersion == null ? 43 : this.osVersion.hashCode());
        result = result * 59 + (this.isRebootRequired == null ? 43 : this.isRebootRequired.hashCode());
        result = result * 59 + (this.timeReplaced == null ? 43 : this.timeReplaced.hashCode());
        result = result * 59 + (this.nodeBackupId == null ? 43 : this.nodeBackupId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NodeType implements BmcEnum
    {
        Master("MASTER"),
        Edge("EDGE"),
        Utility("UTILITY"),
        Worker("WORKER"),
        ComputeOnlyWorker("COMPUTE_ONLY_WORKER"),
        KafkaBroker("KAFKA_BROKER"),
        Bursting("BURSTING"),
        CloudSql("CLOUD_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NodeType> map;

        private NodeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NodeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NodeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NodeType.class);
            map = new HashMap<String, NodeType>();
            for (NodeType v : NodeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Stopped("STOPPED"),
        Stopping("STOPPING"),
        Starting("STARTING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="nodeType")
        private NodeType nodeType;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="attachedBlockVolumes")
        private List<VolumeAttachmentDetail> attachedBlockVolumes;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonProperty(value="sshFingerprint")
        private String sshFingerprint;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="ocpus")
        private Integer ocpus;
        @JsonProperty(value="memoryInGBs")
        private Integer memoryInGBs;
        @JsonProperty(value="nvmes")
        private Integer nvmes;
        @JsonProperty(value="localDisksTotalSizeInGBs")
        private Double localDisksTotalSizeInGBs;
        @JsonProperty(value="timeMaintenanceRebootDue")
        private Date timeMaintenanceRebootDue;
        @JsonProperty(value="osVersion")
        private String osVersion;
        @JsonProperty(value="isRebootRequired")
        private Boolean isRebootRequired;
        @JsonProperty(value="timeReplaced")
        private Date timeReplaced;
        @JsonProperty(value="nodeBackupId")
        private String nodeBackupId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            this.__explicitlySet__.add("nodeType");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder attachedBlockVolumes(List<VolumeAttachmentDetail> attachedBlockVolumes) {
            this.attachedBlockVolumes = attachedBlockVolumes;
            this.__explicitlySet__.add("attachedBlockVolumes");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public Builder sshFingerprint(String sshFingerprint) {
            this.sshFingerprint = sshFingerprint;
            this.__explicitlySet__.add("sshFingerprint");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder ocpus(Integer ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder memoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder nvmes(Integer nvmes) {
            this.nvmes = nvmes;
            this.__explicitlySet__.add("nvmes");
            return this;
        }

        public Builder localDisksTotalSizeInGBs(Double localDisksTotalSizeInGBs) {
            this.localDisksTotalSizeInGBs = localDisksTotalSizeInGBs;
            this.__explicitlySet__.add("localDisksTotalSizeInGBs");
            return this;
        }

        public Builder timeMaintenanceRebootDue(Date timeMaintenanceRebootDue) {
            this.timeMaintenanceRebootDue = timeMaintenanceRebootDue;
            this.__explicitlySet__.add("timeMaintenanceRebootDue");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.__explicitlySet__.add("osVersion");
            return this;
        }

        public Builder isRebootRequired(Boolean isRebootRequired) {
            this.isRebootRequired = isRebootRequired;
            this.__explicitlySet__.add("isRebootRequired");
            return this;
        }

        public Builder timeReplaced(Date timeReplaced) {
            this.timeReplaced = timeReplaced;
            this.__explicitlySet__.add("timeReplaced");
            return this;
        }

        public Builder nodeBackupId(String nodeBackupId) {
            this.nodeBackupId = nodeBackupId;
            this.__explicitlySet__.add("nodeBackupId");
            return this;
        }

        public Node build() {
            Node model = new Node(this.instanceId, this.displayName, this.lifecycleState, this.nodeType, this.shape, this.attachedBlockVolumes, this.subnetId, this.ipAddress, this.hostname, this.imageId, this.sshFingerprint, this.availabilityDomain, this.faultDomain, this.timeCreated, this.timeUpdated, this.ocpus, this.memoryInGBs, this.nvmes, this.localDisksTotalSizeInGBs, this.timeMaintenanceRebootDue, this.osVersion, this.isRebootRequired, this.timeReplaced, this.nodeBackupId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Node model) {
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("nodeType")) {
                this.nodeType(model.getNodeType());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("attachedBlockVolumes")) {
                this.attachedBlockVolumes(model.getAttachedBlockVolumes());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("sshFingerprint")) {
                this.sshFingerprint(model.getSshFingerprint());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("nvmes")) {
                this.nvmes(model.getNvmes());
            }
            if (model.wasPropertyExplicitlySet("localDisksTotalSizeInGBs")) {
                this.localDisksTotalSizeInGBs(model.getLocalDisksTotalSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("timeMaintenanceRebootDue")) {
                this.timeMaintenanceRebootDue(model.getTimeMaintenanceRebootDue());
            }
            if (model.wasPropertyExplicitlySet("osVersion")) {
                this.osVersion(model.getOsVersion());
            }
            if (model.wasPropertyExplicitlySet("isRebootRequired")) {
                this.isRebootRequired(model.getIsRebootRequired());
            }
            if (model.wasPropertyExplicitlySet("timeReplaced")) {
                this.timeReplaced(model.getTimeReplaced());
            }
            if (model.wasPropertyExplicitlySet("nodeBackupId")) {
                this.nodeBackupId(model.getNodeBackupId());
            }
            return this;
        }
    }
}

