/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OsPatchPackageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="packageName")
    private final String packageName;
    @JsonProperty(value="targetVersion")
    private final String targetVersion;
    @JsonProperty(value="updateType")
    private final UpdateType updateType;
    @JsonProperty(value="relatedCVEs")
    private final List<String> relatedCVEs;

    @Deprecated
    @ConstructorProperties(value={"packageName", "targetVersion", "updateType", "relatedCVEs"})
    public OsPatchPackageSummary(String packageName, String targetVersion, UpdateType updateType, List<String> relatedCVEs) {
        this.packageName = packageName;
        this.targetVersion = targetVersion;
        this.updateType = updateType;
        this.relatedCVEs = relatedCVEs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public List<String> getRelatedCVEs() {
        return this.relatedCVEs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OsPatchPackageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("packageName=").append(String.valueOf(this.packageName));
        sb.append(", targetVersion=").append(String.valueOf(this.targetVersion));
        sb.append(", updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(", relatedCVEs=").append(String.valueOf(this.relatedCVEs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OsPatchPackageSummary)) {
            return false;
        }
        OsPatchPackageSummary other = (OsPatchPackageSummary)((Object)o);
        return Objects.equals(this.packageName, other.packageName) && Objects.equals(this.targetVersion, other.targetVersion) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals(this.relatedCVEs, other.relatedCVEs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.packageName == null ? 43 : this.packageName.hashCode());
        result = result * 59 + (this.targetVersion == null ? 43 : this.targetVersion.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.relatedCVEs == null ? 43 : this.relatedCVEs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UpdateType implements BmcEnum
    {
        Install("INSTALL"),
        Remove("REMOVE"),
        Update("UPDATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UpdateType> map;

        private UpdateType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpdateType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UpdateType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UpdateType.class);
            map = new HashMap<String, UpdateType>();
            for (UpdateType v : UpdateType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="packageName")
        private String packageName;
        @JsonProperty(value="targetVersion")
        private String targetVersion;
        @JsonProperty(value="updateType")
        private UpdateType updateType;
        @JsonProperty(value="relatedCVEs")
        private List<String> relatedCVEs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            this.__explicitlySet__.add("packageName");
            return this;
        }

        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            this.__explicitlySet__.add("targetVersion");
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder relatedCVEs(List<String> relatedCVEs) {
            this.relatedCVEs = relatedCVEs;
            this.__explicitlySet__.add("relatedCVEs");
            return this;
        }

        public OsPatchPackageSummary build() {
            OsPatchPackageSummary model = new OsPatchPackageSummary(this.packageName, this.targetVersion, this.updateType, this.relatedCVEs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OsPatchPackageSummary model) {
            if (model.wasPropertyExplicitlySet("packageName")) {
                this.packageName(model.getPackageName());
            }
            if (model.wasPropertyExplicitlySet("targetVersion")) {
                this.targetVersion(model.getTargetVersion());
            }
            if (model.wasPropertyExplicitlySet("updateType")) {
                this.updateType(model.getUpdateType());
            }
            if (model.wasPropertyExplicitlySet("relatedCVEs")) {
                this.relatedCVEs(model.getRelatedCVEs());
            }
            return this;
        }
    }
}

