/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.bds.model.CreateNodeBackupConfigurationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateNodeBackupConfigurationRequest
extends BmcRequest<CreateNodeBackupConfigurationDetails> {
    private String bdsInstanceId;
    private CreateNodeBackupConfigurationDetails createNodeBackupConfigurationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public CreateNodeBackupConfigurationDetails getCreateNodeBackupConfigurationDetails() {
        return this.createNodeBackupConfigurationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateNodeBackupConfigurationDetails getBody$() {
        return this.createNodeBackupConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).createNodeBackupConfigurationDetails(this.createNodeBackupConfigurationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",createNodeBackupConfigurationDetails=").append(String.valueOf((Object)this.createNodeBackupConfigurationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateNodeBackupConfigurationRequest)) {
            return false;
        }
        CreateNodeBackupConfigurationRequest other = (CreateNodeBackupConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals((Object)this.createNodeBackupConfigurationDetails, (Object)other.createNodeBackupConfigurationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.createNodeBackupConfigurationDetails == null ? 43 : this.createNodeBackupConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateNodeBackupConfigurationRequest, CreateNodeBackupConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private CreateNodeBackupConfigurationDetails createNodeBackupConfigurationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder createNodeBackupConfigurationDetails(CreateNodeBackupConfigurationDetails createNodeBackupConfigurationDetails) {
            this.createNodeBackupConfigurationDetails = createNodeBackupConfigurationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateNodeBackupConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.createNodeBackupConfigurationDetails(o.getCreateNodeBackupConfigurationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateNodeBackupConfigurationRequest build() {
            CreateNodeBackupConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateNodeBackupConfigurationDetails body) {
            this.createNodeBackupConfigurationDetails(body);
            return this;
        }

        public CreateNodeBackupConfigurationRequest buildWithoutInvocationCallback() {
            CreateNodeBackupConfigurationRequest request = new CreateNodeBackupConfigurationRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.createNodeBackupConfigurationDetails = this.createNodeBackupConfigurationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

