/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.bds.model.CreateNodeReplaceConfigurationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateNodeReplaceConfigurationRequest
extends BmcRequest<CreateNodeReplaceConfigurationDetails> {
    private String bdsInstanceId;
    private CreateNodeReplaceConfigurationDetails createNodeReplaceConfigurationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public CreateNodeReplaceConfigurationDetails getCreateNodeReplaceConfigurationDetails() {
        return this.createNodeReplaceConfigurationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateNodeReplaceConfigurationDetails getBody$() {
        return this.createNodeReplaceConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).createNodeReplaceConfigurationDetails(this.createNodeReplaceConfigurationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",createNodeReplaceConfigurationDetails=").append(String.valueOf((Object)this.createNodeReplaceConfigurationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateNodeReplaceConfigurationRequest)) {
            return false;
        }
        CreateNodeReplaceConfigurationRequest other = (CreateNodeReplaceConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals((Object)this.createNodeReplaceConfigurationDetails, (Object)other.createNodeReplaceConfigurationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.createNodeReplaceConfigurationDetails == null ? 43 : this.createNodeReplaceConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateNodeReplaceConfigurationRequest, CreateNodeReplaceConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private CreateNodeReplaceConfigurationDetails createNodeReplaceConfigurationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder createNodeReplaceConfigurationDetails(CreateNodeReplaceConfigurationDetails createNodeReplaceConfigurationDetails) {
            this.createNodeReplaceConfigurationDetails = createNodeReplaceConfigurationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateNodeReplaceConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.createNodeReplaceConfigurationDetails(o.getCreateNodeReplaceConfigurationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateNodeReplaceConfigurationRequest build() {
            CreateNodeReplaceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateNodeReplaceConfigurationDetails body) {
            this.createNodeReplaceConfigurationDetails(body);
            return this;
        }

        public CreateNodeReplaceConfigurationRequest buildWithoutInvocationCallback() {
            CreateNodeReplaceConfigurationRequest request = new CreateNodeReplaceConfigurationRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.createNodeReplaceConfigurationDetails = this.createNodeReplaceConfigurationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

