/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.model.AutoScalingConfiguration;
import com.oracle.bmc.bds.model.BdsApiKey;
import com.oracle.bmc.bds.model.BdsInstance;
import com.oracle.bmc.bds.model.BdsMetastoreConfiguration;
import com.oracle.bmc.bds.model.NodeBackup;
import com.oracle.bmc.bds.model.NodeBackupConfiguration;
import com.oracle.bmc.bds.model.NodeReplaceConfiguration;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsApiKeyRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetBdsMetastoreConfigurationRequest;
import com.oracle.bmc.bds.requests.GetNodeBackupConfigurationRequest;
import com.oracle.bmc.bds.requests.GetNodeBackupRequest;
import com.oracle.bmc.bds.requests.GetNodeReplaceConfigurationRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsApiKeyResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetBdsMetastoreConfigurationResponse;
import com.oracle.bmc.bds.responses.GetNodeBackupConfigurationResponse;
import com.oracle.bmc.bds.responses.GetNodeBackupResponse;
import com.oracle.bmc.bds.responses.GetNodeReplaceConfigurationResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class BdsWaiters {
    private final ExecutorService executorService;
    private final Bds client;

    public BdsWaiters(ExecutorService executorService, Bds client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutoScalingConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(BmcGenericWaiter waiter, GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState ... targetStates) {
        final HashSet<AutoScalingConfiguration.LifecycleState> targetStatesSet = new HashSet<AutoScalingConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>(){

            @Override
            public GetAutoScalingConfigurationResponse apply(GetAutoScalingConfigurationRequest request) {
                return BdsWaiters.this.client.getAutoScalingConfiguration(request);
            }
        }, (Predicate)new Predicate<GetAutoScalingConfigurationResponse>(){

            @Override
            public boolean test(GetAutoScalingConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getAutoScalingConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutoScalingConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(GetBdsApiKeyRequest request, BdsApiKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsApiKey(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(GetBdsApiKeyRequest request, BdsApiKey.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsApiKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(GetBdsApiKeyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsApiKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsApiKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsApiKeyRequest, GetBdsApiKeyResponse> forBdsApiKey(BmcGenericWaiter waiter, GetBdsApiKeyRequest request, BdsApiKey.LifecycleState ... targetStates) {
        final HashSet<BdsApiKey.LifecycleState> targetStatesSet = new HashSet<BdsApiKey.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBdsApiKeyRequest, GetBdsApiKeyResponse>(){

            @Override
            public GetBdsApiKeyResponse apply(GetBdsApiKeyRequest request) {
                return BdsWaiters.this.client.getBdsApiKey(request);
            }
        }, (Predicate)new Predicate<GetBdsApiKeyResponse>(){

            @Override
            public boolean test(GetBdsApiKeyResponse response) {
                return targetStatesSet.contains((Object)response.getBdsApiKey().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsApiKey.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, BdsInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, BdsInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(BmcGenericWaiter waiter, GetBdsInstanceRequest request, BdsInstance.LifecycleState ... targetStates) {
        final HashSet<BdsInstance.LifecycleState> targetStatesSet = new HashSet<BdsInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBdsInstanceRequest, GetBdsInstanceResponse>(){

            @Override
            public GetBdsInstanceResponse apply(GetBdsInstanceRequest request) {
                return BdsWaiters.this.client.getBdsInstance(request);
            }
        }, (Predicate)new Predicate<GetBdsInstanceResponse>(){

            @Override
            public boolean test(GetBdsInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getBdsInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request, BdsMetastoreConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsMetastoreConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request, BdsMetastoreConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsMetastoreConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(GetBdsMetastoreConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsMetastoreConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsMetastoreConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse> forBdsMetastoreConfiguration(BmcGenericWaiter waiter, GetBdsMetastoreConfigurationRequest request, BdsMetastoreConfiguration.LifecycleState ... targetStates) {
        final HashSet<BdsMetastoreConfiguration.LifecycleState> targetStatesSet = new HashSet<BdsMetastoreConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBdsMetastoreConfigurationRequest, GetBdsMetastoreConfigurationResponse>(){

            @Override
            public GetBdsMetastoreConfigurationResponse apply(GetBdsMetastoreConfigurationRequest request) {
                return BdsWaiters.this.client.getBdsMetastoreConfiguration(request);
            }
        }, (Predicate)new Predicate<GetBdsMetastoreConfigurationResponse>(){

            @Override
            public boolean test(GetBdsMetastoreConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getBdsMetastoreConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsMetastoreConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetNodeBackupRequest, GetNodeBackupResponse> forNodeBackup(GetNodeBackupRequest request, NodeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNodeBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNodeBackupRequest, GetNodeBackupResponse> forNodeBackup(GetNodeBackupRequest request, NodeBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNodeBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNodeBackupRequest, GetNodeBackupResponse> forNodeBackup(GetNodeBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NodeBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNodeBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNodeBackupRequest, GetNodeBackupResponse> forNodeBackup(BmcGenericWaiter waiter, GetNodeBackupRequest request, NodeBackup.LifecycleState ... targetStates) {
        final HashSet<NodeBackup.LifecycleState> targetStatesSet = new HashSet<NodeBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNodeBackupRequest, GetNodeBackupResponse>(){

            @Override
            public GetNodeBackupResponse apply(GetNodeBackupRequest request) {
                return BdsWaiters.this.client.getNodeBackup(request);
            }
        }, (Predicate)new Predicate<GetNodeBackupResponse>(){

            @Override
            public boolean test(GetNodeBackupResponse response) {
                return targetStatesSet.contains((Object)response.getNodeBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NodeBackup.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetNodeBackupConfigurationRequest, GetNodeBackupConfigurationResponse> forNodeBackupConfiguration(GetNodeBackupConfigurationRequest request, NodeBackupConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNodeBackupConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNodeBackupConfigurationRequest, GetNodeBackupConfigurationResponse> forNodeBackupConfiguration(GetNodeBackupConfigurationRequest request, NodeBackupConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNodeBackupConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNodeBackupConfigurationRequest, GetNodeBackupConfigurationResponse> forNodeBackupConfiguration(GetNodeBackupConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NodeBackupConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNodeBackupConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNodeBackupConfigurationRequest, GetNodeBackupConfigurationResponse> forNodeBackupConfiguration(BmcGenericWaiter waiter, GetNodeBackupConfigurationRequest request, NodeBackupConfiguration.LifecycleState ... targetStates) {
        final HashSet<NodeBackupConfiguration.LifecycleState> targetStatesSet = new HashSet<NodeBackupConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNodeBackupConfigurationRequest, GetNodeBackupConfigurationResponse>(){

            @Override
            public GetNodeBackupConfigurationResponse apply(GetNodeBackupConfigurationRequest request) {
                return BdsWaiters.this.client.getNodeBackupConfiguration(request);
            }
        }, (Predicate)new Predicate<GetNodeBackupConfigurationResponse>(){

            @Override
            public boolean test(GetNodeBackupConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getNodeBackupConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NodeBackupConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetNodeReplaceConfigurationRequest, GetNodeReplaceConfigurationResponse> forNodeReplaceConfiguration(GetNodeReplaceConfigurationRequest request, NodeReplaceConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNodeReplaceConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNodeReplaceConfigurationRequest, GetNodeReplaceConfigurationResponse> forNodeReplaceConfiguration(GetNodeReplaceConfigurationRequest request, NodeReplaceConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNodeReplaceConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNodeReplaceConfigurationRequest, GetNodeReplaceConfigurationResponse> forNodeReplaceConfiguration(GetNodeReplaceConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NodeReplaceConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNodeReplaceConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNodeReplaceConfigurationRequest, GetNodeReplaceConfigurationResponse> forNodeReplaceConfiguration(BmcGenericWaiter waiter, GetNodeReplaceConfigurationRequest request, NodeReplaceConfiguration.LifecycleState ... targetStates) {
        final HashSet<NodeReplaceConfiguration.LifecycleState> targetStatesSet = new HashSet<NodeReplaceConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNodeReplaceConfigurationRequest, GetNodeReplaceConfigurationResponse>(){

            @Override
            public GetNodeReplaceConfigurationResponse apply(GetNodeReplaceConfigurationRequest request) {
                return BdsWaiters.this.client.getNodeReplaceConfiguration(request);
            }
        }, (Predicate)new Predicate<GetNodeReplaceConfigurationResponse>(){

            @Override
            public boolean test(GetNodeReplaceConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getNodeReplaceConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NodeReplaceConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return BdsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

