/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostSpecificCertificateDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="certificateType")
    private final CertificateType certificateType;
    @JsonProperty(value="timeExpiry")
    private final Date timeExpiry;

    @Deprecated
    @ConstructorProperties(value={"hostName", "certificateType", "timeExpiry"})
    public HostSpecificCertificateDetails(String hostName, CertificateType certificateType, Date timeExpiry) {
        this.hostName = hostName;
        this.certificateType = certificateType;
        this.timeExpiry = timeExpiry;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public CertificateType getCertificateType() {
        return this.certificateType;
    }

    public Date getTimeExpiry() {
        return this.timeExpiry;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostSpecificCertificateDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostName=").append(String.valueOf(this.hostName));
        sb.append(", certificateType=").append(String.valueOf((Object)this.certificateType));
        sb.append(", timeExpiry=").append(String.valueOf(this.timeExpiry));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostSpecificCertificateDetails)) {
            return false;
        }
        HostSpecificCertificateDetails other = (HostSpecificCertificateDetails)((Object)o);
        return Objects.equals(this.hostName, other.hostName) && Objects.equals((Object)this.certificateType, (Object)other.certificateType) && Objects.equals(this.timeExpiry, other.timeExpiry) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.certificateType == null ? 43 : this.certificateType.hashCode());
        result = result * 59 + (this.timeExpiry == null ? 43 : this.timeExpiry.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CertificateType implements BmcEnum
    {
        CustomSigned("CUSTOM_SIGNED"),
        SelfSigned("SELF_SIGNED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CertificateType> map;

        private CertificateType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CertificateType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CertificateType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CertificateType.class);
            map = new HashMap<String, CertificateType>();
            for (CertificateType v : CertificateType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="certificateType")
        private CertificateType certificateType;
        @JsonProperty(value="timeExpiry")
        private Date timeExpiry;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder certificateType(CertificateType certificateType) {
            this.certificateType = certificateType;
            this.__explicitlySet__.add("certificateType");
            return this;
        }

        public Builder timeExpiry(Date timeExpiry) {
            this.timeExpiry = timeExpiry;
            this.__explicitlySet__.add("timeExpiry");
            return this;
        }

        public HostSpecificCertificateDetails build() {
            HostSpecificCertificateDetails model = new HostSpecificCertificateDetails(this.hostName, this.certificateType, this.timeExpiry);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostSpecificCertificateDetails model) {
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("certificateType")) {
                this.certificateType(model.getCertificateType());
            }
            if (model.wasPropertyExplicitlySet("timeExpiry")) {
                this.timeExpiry(model.getTimeExpiry());
            }
            return this;
        }
    }
}

