/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.OsPatchPackageSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OsPatchDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="osPatchVersion")
    private final String osPatchVersion;
    @JsonProperty(value="minBdsVersion")
    private final String minBdsVersion;
    @JsonProperty(value="minCompatibleOdhVersionMap")
    private final Map<String, String> minCompatibleOdhVersionMap;
    @JsonProperty(value="targetPackages")
    private final List<OsPatchPackageSummary> targetPackages;
    @JsonProperty(value="releaseDate")
    private final Date releaseDate;
    @JsonProperty(value="patchType")
    private final PatchType patchType;

    @Deprecated
    @ConstructorProperties(value={"osPatchVersion", "minBdsVersion", "minCompatibleOdhVersionMap", "targetPackages", "releaseDate", "patchType"})
    public OsPatchDetails(String osPatchVersion, String minBdsVersion, Map<String, String> minCompatibleOdhVersionMap, List<OsPatchPackageSummary> targetPackages, Date releaseDate, PatchType patchType) {
        this.osPatchVersion = osPatchVersion;
        this.minBdsVersion = minBdsVersion;
        this.minCompatibleOdhVersionMap = minCompatibleOdhVersionMap;
        this.targetPackages = targetPackages;
        this.releaseDate = releaseDate;
        this.patchType = patchType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOsPatchVersion() {
        return this.osPatchVersion;
    }

    public String getMinBdsVersion() {
        return this.minBdsVersion;
    }

    public Map<String, String> getMinCompatibleOdhVersionMap() {
        return this.minCompatibleOdhVersionMap;
    }

    public List<OsPatchPackageSummary> getTargetPackages() {
        return this.targetPackages;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public PatchType getPatchType() {
        return this.patchType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OsPatchDetails(");
        sb.append("super=").append(super.toString());
        sb.append("osPatchVersion=").append(String.valueOf(this.osPatchVersion));
        sb.append(", minBdsVersion=").append(String.valueOf(this.minBdsVersion));
        sb.append(", minCompatibleOdhVersionMap=").append(String.valueOf(this.minCompatibleOdhVersionMap));
        sb.append(", targetPackages=").append(String.valueOf(this.targetPackages));
        sb.append(", releaseDate=").append(String.valueOf(this.releaseDate));
        sb.append(", patchType=").append(String.valueOf((Object)this.patchType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OsPatchDetails)) {
            return false;
        }
        OsPatchDetails other = (OsPatchDetails)((Object)o);
        return Objects.equals(this.osPatchVersion, other.osPatchVersion) && Objects.equals(this.minBdsVersion, other.minBdsVersion) && Objects.equals(this.minCompatibleOdhVersionMap, other.minCompatibleOdhVersionMap) && Objects.equals(this.targetPackages, other.targetPackages) && Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals((Object)this.patchType, (Object)other.patchType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.osPatchVersion == null ? 43 : this.osPatchVersion.hashCode());
        result = result * 59 + (this.minBdsVersion == null ? 43 : this.minBdsVersion.hashCode());
        result = result * 59 + (this.minCompatibleOdhVersionMap == null ? 43 : this.minCompatibleOdhVersionMap.hashCode());
        result = result * 59 + (this.targetPackages == null ? 43 : this.targetPackages.hashCode());
        result = result * 59 + (this.releaseDate == null ? 43 : this.releaseDate.hashCode());
        result = result * 59 + (this.patchType == null ? 43 : this.patchType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchType implements BmcEnum
    {
        Regular("REGULAR"),
        Custom("CUSTOM"),
        Emergent("EMERGENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchType> map;

        private PatchType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchType.class);
            map = new HashMap<String, PatchType>();
            for (PatchType v : PatchType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="osPatchVersion")
        private String osPatchVersion;
        @JsonProperty(value="minBdsVersion")
        private String minBdsVersion;
        @JsonProperty(value="minCompatibleOdhVersionMap")
        private Map<String, String> minCompatibleOdhVersionMap;
        @JsonProperty(value="targetPackages")
        private List<OsPatchPackageSummary> targetPackages;
        @JsonProperty(value="releaseDate")
        private Date releaseDate;
        @JsonProperty(value="patchType")
        private PatchType patchType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder osPatchVersion(String osPatchVersion) {
            this.osPatchVersion = osPatchVersion;
            this.__explicitlySet__.add("osPatchVersion");
            return this;
        }

        public Builder minBdsVersion(String minBdsVersion) {
            this.minBdsVersion = minBdsVersion;
            this.__explicitlySet__.add("minBdsVersion");
            return this;
        }

        public Builder minCompatibleOdhVersionMap(Map<String, String> minCompatibleOdhVersionMap) {
            this.minCompatibleOdhVersionMap = minCompatibleOdhVersionMap;
            this.__explicitlySet__.add("minCompatibleOdhVersionMap");
            return this;
        }

        public Builder targetPackages(List<OsPatchPackageSummary> targetPackages) {
            this.targetPackages = targetPackages;
            this.__explicitlySet__.add("targetPackages");
            return this;
        }

        public Builder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.__explicitlySet__.add("releaseDate");
            return this;
        }

        public Builder patchType(PatchType patchType) {
            this.patchType = patchType;
            this.__explicitlySet__.add("patchType");
            return this;
        }

        public OsPatchDetails build() {
            OsPatchDetails model = new OsPatchDetails(this.osPatchVersion, this.minBdsVersion, this.minCompatibleOdhVersionMap, this.targetPackages, this.releaseDate, this.patchType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OsPatchDetails model) {
            if (model.wasPropertyExplicitlySet("osPatchVersion")) {
                this.osPatchVersion(model.getOsPatchVersion());
            }
            if (model.wasPropertyExplicitlySet("minBdsVersion")) {
                this.minBdsVersion(model.getMinBdsVersion());
            }
            if (model.wasPropertyExplicitlySet("minCompatibleOdhVersionMap")) {
                this.minCompatibleOdhVersionMap(model.getMinCompatibleOdhVersionMap());
            }
            if (model.wasPropertyExplicitlySet("targetPackages")) {
                this.targetPackages(model.getTargetPackages());
            }
            if (model.wasPropertyExplicitlySet("releaseDate")) {
                this.releaseDate(model.getReleaseDate());
            }
            if (model.wasPropertyExplicitlySet("patchType")) {
                this.patchType(model.getPatchType());
            }
            return this;
        }
    }
}

