/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.bds.model.NodeBackup;
import com.oracle.bmc.bds.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListNodeBackupsRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String nodeHostName;
    private NodeBackup.LifecycleState lifecycleState;
    private String opcRequestId;
    private String displayName;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getNodeHostName() {
        return this.nodeHostName;
    }

    public NodeBackup.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).nodeHostName(this.nodeHostName).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId).displayName(this.displayName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",nodeHostName=").append(String.valueOf(this.nodeHostName));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListNodeBackupsRequest)) {
            return false;
        }
        ListNodeBackupsRequest other = (ListNodeBackupsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.nodeHostName, other.nodeHostName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.displayName, other.displayName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.nodeHostName == null ? 43 : this.nodeHostName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListNodeBackupsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String nodeHostName = null;
        private NodeBackup.LifecycleState lifecycleState = null;
        private String opcRequestId = null;
        private String displayName = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder nodeHostName(String nodeHostName) {
            this.nodeHostName = nodeHostName;
            return this;
        }

        public Builder lifecycleState(NodeBackup.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListNodeBackupsRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.nodeHostName(o.getNodeHostName());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.displayName(o.getDisplayName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListNodeBackupsRequest build() {
            ListNodeBackupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListNodeBackupsRequest buildWithoutInvocationCallback() {
            ListNodeBackupsRequest request = new ListNodeBackupsRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.nodeHostName = this.nodeHostName;
            request.lifecycleState = this.lifecycleState;
            request.opcRequestId = this.opcRequestId;
            request.displayName = this.displayName;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

