/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.OdhPatchingConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="patchingConfigStrategy")
@JsonFilter(value="explicitlySetFilter")
public final class BatchingBasedOdhPatchingConfig
extends OdhPatchingConfig {
    @JsonProperty(value="batchSize")
    private final Integer batchSize;
    @JsonProperty(value="waitTimeBetweenBatchInSeconds")
    private final Integer waitTimeBetweenBatchInSeconds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BatchingBasedOdhPatchingConfig(Integer batchSize, Integer waitTimeBetweenBatchInSeconds) {
        this.batchSize = batchSize;
        this.waitTimeBetweenBatchInSeconds = waitTimeBetweenBatchInSeconds;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getWaitTimeBetweenBatchInSeconds() {
        return this.waitTimeBetweenBatchInSeconds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchingBasedOdhPatchingConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", batchSize=").append(String.valueOf(this.batchSize));
        sb.append(", waitTimeBetweenBatchInSeconds=").append(String.valueOf(this.waitTimeBetweenBatchInSeconds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchingBasedOdhPatchingConfig)) {
            return false;
        }
        BatchingBasedOdhPatchingConfig other = (BatchingBasedOdhPatchingConfig)((Object)o);
        return Objects.equals(this.batchSize, other.batchSize) && Objects.equals(this.waitTimeBetweenBatchInSeconds, other.waitTimeBetweenBatchInSeconds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.batchSize == null ? 43 : this.batchSize.hashCode());
        result = result * 59 + (this.waitTimeBetweenBatchInSeconds == null ? 43 : this.waitTimeBetweenBatchInSeconds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="batchSize")
        private Integer batchSize;
        @JsonProperty(value="waitTimeBetweenBatchInSeconds")
        private Integer waitTimeBetweenBatchInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            this.__explicitlySet__.add("batchSize");
            return this;
        }

        public Builder waitTimeBetweenBatchInSeconds(Integer waitTimeBetweenBatchInSeconds) {
            this.waitTimeBetweenBatchInSeconds = waitTimeBetweenBatchInSeconds;
            this.__explicitlySet__.add("waitTimeBetweenBatchInSeconds");
            return this;
        }

        public BatchingBasedOdhPatchingConfig build() {
            BatchingBasedOdhPatchingConfig model = new BatchingBasedOdhPatchingConfig(this.batchSize, this.waitTimeBetweenBatchInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BatchingBasedOdhPatchingConfig model) {
            if (model.wasPropertyExplicitlySet("batchSize")) {
                this.batchSize(model.getBatchSize());
            }
            if (model.wasPropertyExplicitlySet("waitTimeBetweenBatchInSeconds")) {
                this.waitTimeBetweenBatchInSeconds(model.getWaitTimeBetweenBatchInSeconds());
            }
            return this;
        }
    }
}

