/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostCertDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="certificate")
    private final String certificate;
    @JsonProperty(value="privateKey")
    private final String privateKey;

    @Deprecated
    @ConstructorProperties(value={"hostName", "certificate", "privateKey"})
    public HostCertDetails(String hostName, String certificate, String privateKey) {
        this.hostName = hostName;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostCertDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostName=").append(String.valueOf(this.hostName));
        sb.append(", certificate=").append(String.valueOf(this.certificate));
        sb.append(", privateKey=").append(String.valueOf(this.privateKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostCertDetails)) {
            return false;
        }
        HostCertDetails other = (HostCertDetails)((Object)o);
        return Objects.equals(this.hostName, other.hostName) && Objects.equals(this.certificate, other.certificate) && Objects.equals(this.privateKey, other.privateKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.certificate == null ? 43 : this.certificate.hashCode());
        result = result * 59 + (this.privateKey == null ? 43 : this.privateKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="certificate")
        private String certificate;
        @JsonProperty(value="privateKey")
        private String privateKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder certificate(String certificate) {
            this.certificate = certificate;
            this.__explicitlySet__.add("certificate");
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            this.__explicitlySet__.add("privateKey");
            return this;
        }

        public HostCertDetails build() {
            HostCertDetails model = new HostCertDetails(this.hostName, this.certificate, this.privateKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostCertDetails model) {
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("certificate")) {
                this.certificate(model.getCertificate());
            }
            if (model.wasPropertyExplicitlySet("privateKey")) {
                this.privateKey(model.getPrivateKey());
            }
            return this;
        }
    }
}

