/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.PatchingConfigs;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstallOsPatchDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="osPatchVersion")
    private final String osPatchVersion;
    @JsonProperty(value="clusterAdminPassword")
    private final String clusterAdminPassword;
    @JsonProperty(value="patchingConfigs")
    private final PatchingConfigs patchingConfigs;

    @Deprecated
    @ConstructorProperties(value={"osPatchVersion", "clusterAdminPassword", "patchingConfigs"})
    public InstallOsPatchDetails(String osPatchVersion, String clusterAdminPassword, PatchingConfigs patchingConfigs) {
        this.osPatchVersion = osPatchVersion;
        this.clusterAdminPassword = clusterAdminPassword;
        this.patchingConfigs = patchingConfigs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOsPatchVersion() {
        return this.osPatchVersion;
    }

    public String getClusterAdminPassword() {
        return this.clusterAdminPassword;
    }

    public PatchingConfigs getPatchingConfigs() {
        return this.patchingConfigs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstallOsPatchDetails(");
        sb.append("super=").append(super.toString());
        sb.append("osPatchVersion=").append(String.valueOf(this.osPatchVersion));
        sb.append(", clusterAdminPassword=").append("<redacted>");
        sb.append(", patchingConfigs=").append(String.valueOf((Object)this.patchingConfigs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallOsPatchDetails)) {
            return false;
        }
        InstallOsPatchDetails other = (InstallOsPatchDetails)((Object)o);
        return Objects.equals(this.osPatchVersion, other.osPatchVersion) && Objects.equals(this.clusterAdminPassword, other.clusterAdminPassword) && Objects.equals((Object)this.patchingConfigs, (Object)other.patchingConfigs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.osPatchVersion == null ? 43 : this.osPatchVersion.hashCode());
        result = result * 59 + (this.clusterAdminPassword == null ? 43 : this.clusterAdminPassword.hashCode());
        result = result * 59 + (this.patchingConfigs == null ? 43 : this.patchingConfigs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="osPatchVersion")
        private String osPatchVersion;
        @JsonProperty(value="clusterAdminPassword")
        private String clusterAdminPassword;
        @JsonProperty(value="patchingConfigs")
        private PatchingConfigs patchingConfigs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder osPatchVersion(String osPatchVersion) {
            this.osPatchVersion = osPatchVersion;
            this.__explicitlySet__.add("osPatchVersion");
            return this;
        }

        public Builder clusterAdminPassword(String clusterAdminPassword) {
            this.clusterAdminPassword = clusterAdminPassword;
            this.__explicitlySet__.add("clusterAdminPassword");
            return this;
        }

        public Builder patchingConfigs(PatchingConfigs patchingConfigs) {
            this.patchingConfigs = patchingConfigs;
            this.__explicitlySet__.add("patchingConfigs");
            return this;
        }

        public InstallOsPatchDetails build() {
            InstallOsPatchDetails model = new InstallOsPatchDetails(this.osPatchVersion, this.clusterAdminPassword, this.patchingConfigs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstallOsPatchDetails model) {
            if (model.wasPropertyExplicitlySet("osPatchVersion")) {
                this.osPatchVersion(model.getOsPatchVersion());
            }
            if (model.wasPropertyExplicitlySet("clusterAdminPassword")) {
                this.clusterAdminPassword(model.getClusterAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("patchingConfigs")) {
                this.patchingConfigs(model.getPatchingConfigs());
            }
            return this;
        }
    }
}

