/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.OdhPatchingConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstallPatchDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="clusterAdminPassword")
    private final String clusterAdminPassword;
    @JsonProperty(value="patchingConfig")
    private final OdhPatchingConfig patchingConfig;

    @Deprecated
    @ConstructorProperties(value={"version", "clusterAdminPassword", "patchingConfig"})
    public InstallPatchDetails(String version, String clusterAdminPassword, OdhPatchingConfig patchingConfig) {
        this.version = version;
        this.clusterAdminPassword = clusterAdminPassword;
        this.patchingConfig = patchingConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getClusterAdminPassword() {
        return this.clusterAdminPassword;
    }

    public OdhPatchingConfig getPatchingConfig() {
        return this.patchingConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstallPatchDetails(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", clusterAdminPassword=").append("<redacted>");
        sb.append(", patchingConfig=").append(String.valueOf((Object)this.patchingConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallPatchDetails)) {
            return false;
        }
        InstallPatchDetails other = (InstallPatchDetails)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.clusterAdminPassword, other.clusterAdminPassword) && Objects.equals((Object)this.patchingConfig, (Object)other.patchingConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.clusterAdminPassword == null ? 43 : this.clusterAdminPassword.hashCode());
        result = result * 59 + (this.patchingConfig == null ? 43 : this.patchingConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="clusterAdminPassword")
        private String clusterAdminPassword;
        @JsonProperty(value="patchingConfig")
        private OdhPatchingConfig patchingConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder clusterAdminPassword(String clusterAdminPassword) {
            this.clusterAdminPassword = clusterAdminPassword;
            this.__explicitlySet__.add("clusterAdminPassword");
            return this;
        }

        public Builder patchingConfig(OdhPatchingConfig patchingConfig) {
            this.patchingConfig = patchingConfig;
            this.__explicitlySet__.add("patchingConfig");
            return this;
        }

        public InstallPatchDetails build() {
            InstallPatchDetails model = new InstallPatchDetails(this.version, this.clusterAdminPassword, this.patchingConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstallPatchDetails model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("clusterAdminPassword")) {
                this.clusterAdminPassword(model.getClusterAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("patchingConfig")) {
                this.patchingConfig(model.getPatchingConfig());
            }
            return this;
        }
    }
}

